% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RN_index_screen.R
\name{RN_index_screen}
\alias{RN_index_screen}
\title{Screen radionuclide data to find matches to decay mode, half-life, and total emission energy}
\usage{
RN_index_screen(
  dk_mode = NULL,
  min_half_life_seconds = NULL,
  max_half_life_seconds = NULL,
  min_E_alpha = NULL,
  min_E_electron = NULL,
  min_E_photon = NULL
)
}
\arguments{
\item{dk_mode}{default = NULL
#' select from:
'A' for Alpha
'B-' for Beta Negative
'B+' for Beta Positive
'EC' for Electron Capture
'IT' for Isomeric Transition
'SF' for Spontaneous Fission}

\item{min_half_life_seconds}{default = NULL. If half-life is known in units other than seconds, enter with conversion factor, e.g. for 15 minutes, enter min_half_life_seconds = 15 * 60.}

\item{max_half_life_seconds}{default = NULL. If half-life is known in units other than seconds, enter with conversion factor, e.g. for 30 minutes, enter max_half_life_seconds = 30 * 60.}

\item{min_E_alpha}{default = NULL. This will be used to screen the index for average alpha energy per decay, including all decay branches.}

\item{min_E_electron}{default = NULL. This will be used to screen the index for average electron energy per decay, including all decay branches.}

\item{min_E_photon}{default = NULL. This will be used to screen the index for average photon energy per decay, including all decay branches.}
}
\value{
data frame of radionuclide data from the RadData package index data (RadData::ICRP_07.NDX), matching search criteria.
}
\description{
Provides a set of radionuclides matching screening criteria. This is a limited screening based on average energy per transformation. Consider [search_phot_by_E], [search_alpha_by_E], and [search_beta_by_E] for spectroscopic measurement matching.
}
\examples{
RN_index_screen(dk_mode = "SF")
RN_index_screen(dk_mode = "IT", max_half_life_seconds = 433 * 3.15e7)
}
\seealso{
Other radionuclides: 
\code{\link{RN_Spec_Act}()},
\code{\link{RN_bin_screen_phot}()},
\code{\link{RN_info}()},
\code{\link{RN_plot_search_results}()},
\code{\link{RN_plot_spectrum}()},
\code{\link{RN_save_spectrum}()},
\code{\link{RN_search_alpha_by_E}()},
\code{\link{RN_search_beta_by_E}()},
\code{\link{RN_search_phot_by_E}()}
}
\concept{radionuclides}
