% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.R
\name{em}
\alias{em}
\title{Do ancestry analysis with EM algorithm}
\usage{
em(g, q, f, acc, max.iter, tol, model)
}
\arguments{
\item{g}{Genotype matrix with dimensions \eqn{n × p}, where n is sample size
and p is the number of SNPs.}

\item{q}{Ancestry coefficient matrix with dimensions \eqn{n × K}, where n
is sample size and K is the number of populations.}

\item{f}{Minor allele frequency matrix with dimensions \eqn{K × p},
where K is the number of populations and p is the number of SNPs.}

\item{acc}{a logical value indicating whether use accelerated EM or not.}

\item{max.iter}{an integer. If acc is TRUE, the number of iterations must be set.
max.iter should greater than 1.}

\item{tol}{Tolerance. If acc is FALSE, tol must be set. The default is 1e-4.}

\item{model}{Choose which model you want to use. Supervised learning or unsupervised learning.}
}
\value{
Estimation results of q, f and the loglikelihood value of each iteration.
}
\description{
The EM algorithm could be used for estimating the Q and F matrix.
}
