% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb.R
\name{predict.nb}
\alias{predict.nb}
\title{Predict method for the nb function}
\usage{
\method{predict}{nb}(object, pred_data = NULL, pred_cmd = "",
  pred_names = "", dec = 3, ...)
}
\arguments{
\item{object}{Return value from \code{\link{nb}}}

\item{pred_data}{Provide the dataframe to generate predictions (e.g., titanic). The dataset must contain all columns used in the estimation}

\item{pred_cmd}{Generate predictions using a command. For example, `pclass = levels(pclass)` would produce predictions for the different levels of factor `pclass`. To add another variable, create a vector of prediction strings, (e.g., c('pclass = levels(pclass)', 'age = seq(0,100,20)')}

\item{pred_names}{Names for the predictions to be stored. If one name is provided, only the first column of predictions is stored. If empty, the level in the response variable of the nb model will be used}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the nb function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/nb.html} for an example in Radiant
}
\examples{
result <- nb(titanic, "survived", c("pclass", "sex", "age"))
predict(result, pred_data = titanic)
predict(result, pred_data = titanic, pred_names = c("Yes", "No"))
predict(result, pred_cmd = "pclass = levels(pclass)")
result <- nb(titanic, "pclass", c("survived", "sex", "age"))
predict(result, pred_data = titanic)
predict(result, pred_data = titanic, pred_names = c("1st", "2nd", "3rd"))
predict(result, pred_data = titanic, pred_names = "")

}
\seealso{
\code{\link{nb}} to generate the result

\code{\link{summary.nb}} to summarize results
}
