% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_tabs.R
\name{cross_tabs}
\alias{cross_tabs}
\title{Evaluate associations between categorical variables}
\usage{
cross_tabs(dataset, var1, var2, tab = NULL, data_filter = "")
}
\arguments{
\item{dataset}{Dataset (i.e., a data.frame or table)}

\item{var1}{A categorical variable}

\item{var2}{A categorical variable}

\item{tab}{Table with frequencies as alternative to dataset}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of all variables used in cross_tabs as an object of class cross_tabs
}
\description{
Evaluate associations between categorical variables
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/cross_tabs.html} for an example in Radiant
}
\examples{
cross_tabs(newspaper, "Income", "Newspaper") \%>\% str()
table(select(newspaper, Income, Newspaper)) \%>\% cross_tabs(tab = .)

}
\seealso{
\code{\link{summary.cross_tabs}} to summarize results

\code{\link{plot.cross_tabs}} to plot results
}
