% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_project.R
\name{make_project}
\alias{make_project}
\title{Make an Analysis Project}
\usage{
make_project(
  path,
  type = c("Quarto (analysis.qmd)", "R Markdown (analysis.Rmd)")
)
}
\arguments{
\item{path}{Path automatically set by research_project.dcf (see
\code{./rstudio/templates/project/})}

\item{type}{Choose between "Quarto (analysis.qmd)" or
"R Markdown (analysis.Rmd)"}
}
\value{
Returns nothing.  See description above.
}
\description{
This function makes an R project that includes an analysis.Rmd
or analysis.qmd file using the conflicted and tidyverse packages.  This
project automatically includes an aggressive .gitignore which is designed to
help protect against leaking data (with protected  health information), a
starter bibliography file called "references" (in standard .bib format),
and a stock Citation Style Language (.csl) file for the New England Journal
of Medicine.
}
\details{
Behind the scenes, this function used by research_project.dcf when
a user selects New project... > New Directory > rUM Research Project Template
within the RSutdio IDE. See \code{./rstudio/templates/project/}.
}
\examples{
\dontrun{
  make_project(path = "~/test_project", type = "Quarto (analysis.qmd)")
}
\dontrun{
  make_project(path = "~/test_project", type = "R Markdown (analysis.Rmd)")
}
}
