% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XPSgrowth.R
\name{XPSgrowth}
\alias{XPSgrowth}
\title{XPSgrowth}
\usage{
XPSgrowth(
  data_trees,
  parameters = NULL,
  search_initial_gom = FALSE,
  fitting_method = c("gompertz", "GAM", "brnn"),
  ID_vars = NULL,
  fitted_save = FALSE,
  add_zeros = TRUE,
  add_zeros_before = "min",
  post_process = TRUE,
  unified_parameters = FALSE,
  gom_a = NA,
  gom_b = NA,
  gom_k = NA,
  brnn_neurons = NA,
  gam_k = NA,
  gam_sp = NA,
  gom_a_range = c(3000),
  gom_b_range = seq(50, 1000, 50),
  gom_k_range = seq(1, 500, 2)
)
}
\arguments{
\item{data_trees}{a data frame with ID variables and wood formation data with
columns DOY and Width}

\item{parameters}{a data frame with ID variables and initial parameter values
for the selected methods}

\item{search_initial_gom}{logical, should the algorithm to search initial
Gompertz parameters be applied?}

\item{fitting_method}{vector of one or more methods to be compared:
"gompertz", "gam", "brnn"}

\item{ID_vars}{character vector of variables which indicate column names of
ID variables}

\item{fitted_save}{logical, should the fitted curves be saved in current
working directory?}

\item{add_zeros}{logical, should zero observations at the beginning of
growing season be added?}

\item{add_zeros_before}{if 'min' (character) then zeros will be added prior
to the first observation in each year. Alternatively, users can specify
absolute DOY prior which zeros will be added.}

\item{post_process}{logical, should the post-process algorithm be applied?}

\item{unified_parameters}{logical, if FALSE, the algorithm will use only
manually selected function parameters. See the arguments 'gom_a', 'gom_b',
'gom_k', 'brnn_neurons', 'gam_k' and 'gam_sp'. Default is FALSE}

\item{gom_a}{numeric, the parameter a for the Gompertz function}

\item{gom_b}{numeric, the parameter b for the Gompertz function}

\item{gom_k}{numeric, the parameter k for the Gompertz function}

\item{brnn_neurons}{positive integer, the number of neurons to be used by
the BRNN method}

\item{gam_k}{numeric, the parameter k for General Additive Model (GAM)}

\item{gam_sp}{numeric, the parameter sp for General Additive Model (GAM)}

\item{gom_a_range}{a numerical vector of the possible values of the
parameter a, which is considered in the search for the initial Gompertz
parameter values}

\item{gom_b_range}{a numerical vector of the possible values of the
parameter b, which is considered in the search for the initial Gompertz
parameter values}

\item{gom_k_range}{a numerical vector of the possible values of the
parameter k, which is considered in the search for the initial Gompertz
parameter values}
}
\value{
a list with the following elements:
\enumerate{
 \item $fitted - a data frame with fitted wood formation data
 \item $gompertz_grid_search - a data frame with selected initial parameter values
 \item $gompertz_grid_search_errors - a data frame with unsuccessful cases of gompertz grid search
}
}
\description{
XylemPhloemSeasonalGrowth: This Function fits and compares the selected
methods for modeling seasonal xylem and phloem data.
}
\examples{
library(rTG)

# Load data
data(parameters)
data(data_trees)
simulation_1 <- XPSgrowth(data_trees = data_trees,
     parameters = parameters,
     ID_vars = c("Species", "Tissue", "Site", "Year", "Tree"),
     fitting_method = c("gam", "brnn"),
     fitted_save = FALSE,
     search_initial_gom = FALSE,
     add_zeros = TRUE,
     add_zeros_before = 'min',
     post_process = TRUE)
}
