/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.zipimport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.core.ArgParser;
import org.python.core.BytecodeLoader;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.imp;
import org.python.core.util.FileUtil;
import org.python.core.util.StringUtil;
import org.python.expose.ExposedNew;
import org.python.modules.zipimport.zipimport;
import org.python.modules.zipimport.zipimporter$PyExposer;

public class zipimporter
extends PyObject {
    public static final PyType TYPE;
    public static final PyString __doc__;
    static final SearchOrderEntry[] zip_searchorder;
    public String archive;
    public String prefix;
    public PyObject files;
    private PySystemState sys;

    public zipimporter() {
    }

    public zipimporter(PyType subType) {
        super(subType);
    }

    public zipimporter(String path) {
        this.zipimporter___init__(path);
    }

    @ExposedNew
    final void zipimporter___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("__init__", args, kwds, new String[]{"path"});
        String path = ap.getString(0);
        this.zipimporter___init__(path);
    }

    private void zipimporter___init__(String path) {
        if (path == null || path.length() == 0) {
            throw zipimport.ZipImportError("archive path is empty");
        }
        File pathFile = new File(path);
        this.sys = Py.getSystemState();
        this.prefix = "";
        while (true) {
            File fullPathFile;
            if ((fullPathFile = new File(this.sys.getPath(pathFile.getPath()))).isFile()) {
                this.archive = pathFile.getPath();
                break;
            }
            File parentFile = pathFile.getParentFile();
            if (parentFile == null) break;
            String childFile = pathFile.getPath();
            this.prefix = childFile.substring(childFile.lastIndexOf(File.separator) + 1) + File.separator + this.prefix;
            pathFile = parentFile;
        }
        if (this.archive != null) {
            this.files = zipimport._zip_directory_cache.__finditem__(this.archive);
            if (this.files == null) {
                this.files = this.readDirectory(this.archive);
                zipimport._zip_directory_cache.__setitem__(this.archive, this.files);
            }
        } else {
            throw zipimport.ZipImportError("not a Zip file");
        }
        if (this.prefix != "" && !this.prefix.endsWith(File.separator)) {
            this.prefix = this.prefix + File.separator;
        }
    }

    public PyObject find_module(String fullname) {
        return this.zipimporter_find_module(fullname, null);
    }

    public PyObject find_module(String fullname, String path) {
        return this.zipimporter_find_module(fullname, path);
    }

    final PyObject zipimporter_find_module(String fullname, String path) {
        ModuleInfo moduleInfo = this.getModuleInfo(fullname);
        if (moduleInfo == ModuleInfo.ERROR || moduleInfo == ModuleInfo.NOT_FOUND) {
            return Py.None;
        }
        return this;
    }

    public PyObject load_module(String fullname) {
        return this.zipimporter_load_module(fullname);
    }

    final PyObject zipimporter_load_module(String fullname) {
        ModuleCodeData moduleCodeData = this.getModuleCode(fullname);
        if (moduleCodeData == null) {
            return Py.None;
        }
        PyModule mod = imp.addModule(fullname);
        mod.__dict__.__setitem__("__loader__", (PyObject)this);
        if (moduleCodeData.ispackage) {
            String fullpath = this.archive + File.separator + this.prefix + this.getSubname(fullname);
            PyList pkgpath = new PyList();
            pkgpath.add(fullpath);
            mod.__dict__.__setitem__("__path__", (PyObject)pkgpath);
        }
        imp.createFromCode(fullname, moduleCodeData.code, moduleCodeData.path);
        Py.writeDebug("import", "import " + fullname + " # loaded from Zip " + moduleCodeData.path);
        return mod;
    }

    public String get_data(String path) {
        return this.zipimporter_get_data(path);
    }

    final String zipimporter_get_data(String path) {
        byte[] data;
        PyObject tocEntry;
        int len = this.archive.length();
        if (len < path.length() && path.startsWith(this.archive + File.separator)) {
            path = path.substring(len + 1);
        }
        if ((tocEntry = this.files.__finditem__(path)) == null) {
            throw Py.IOError(path);
        }
        ZipBundle zipBundle = this.getDataStream(path);
        try {
            data = FileUtil.readBytes(zipBundle.inputStream);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        finally {
            zipBundle.close();
        }
        return StringUtil.fromBytes(data);
    }

    public boolean is_package(String fullname) {
        return this.zipimporter_is_package(fullname);
    }

    final boolean zipimporter_is_package(String fullname) {
        ModuleInfo moduleInfo = this.getModuleInfo(fullname);
        if (moduleInfo == ModuleInfo.NOT_FOUND) {
            throw zipimport.ZipImportError("can't find module '" + fullname + "'");
        }
        return moduleInfo == ModuleInfo.PACKAGE;
    }

    public PyObject get_code(String fullname) {
        return this.zipimporter_get_code(fullname);
    }

    final PyObject zipimporter_get_code(String fullname) {
        ModuleCodeData moduleCodeData = this.getModuleCode(fullname);
        if (moduleCodeData != null) {
            return moduleCodeData.code;
        }
        return Py.None;
    }

    public String get_source(String fullname) {
        return this.zipimporter_get_source(fullname);
    }

    final String zipimporter_get_source(String fullname) {
        ModuleInfo moduleInfo = this.getModuleInfo(fullname);
        if (moduleInfo == ModuleInfo.ERROR) {
            return null;
        }
        if (moduleInfo == ModuleInfo.NOT_FOUND) {
            throw zipimport.ZipImportError("can't find module '" + fullname + "'");
        }
        String path = this.makeFilename(this.prefix, this.getSubname(fullname));
        path = moduleInfo == ModuleInfo.PACKAGE ? path + File.separator + "__init__.py" : path + ".py";
        PyObject tocEntry = this.files.__finditem__(path);
        if (tocEntry != null) {
            return this.get_data(path);
        }
        return null;
    }

    public ZipBundle getDataStream(String datapath) {
        ZipFile zipArchive;
        datapath = datapath.replace(File.separatorChar, '/');
        try {
            zipArchive = new ZipFile(new File(this.sys.getPath(this.archive)));
        }
        catch (IOException ioe) {
            throw zipimport.ZipImportError("zipimport: can not open file: " + this.archive);
        }
        ZipEntry dataEntry = zipArchive.getEntry(datapath);
        try {
            return new ZipBundle(zipArchive, zipArchive.getInputStream(dataEntry));
        }
        catch (IOException ioe) {
            Py.writeDebug("import", "zipimporter.getDataStream exception: " + ioe.toString());
            throw zipimport.ZipImportError("zipimport: can not open file: " + this.archive);
        }
    }

    private ModuleInfo getModuleInfo(String fullname) {
        String path = this.makeFilename(this.prefix, this.getSubname(fullname));
        for (int i = 0; i < zip_searchorder.length; ++i) {
            SearchOrderEntry entry = zip_searchorder[i];
            PyObject tocEntry = this.files.__finditem__(path + entry.suffix);
            if (tocEntry == null) continue;
            if (entry.type.contains((Object)EntryType.IS_PACKAGE)) {
                return ModuleInfo.PACKAGE;
            }
            return ModuleInfo.MODULE;
        }
        return ModuleInfo.NOT_FOUND;
    }

    private ModuleCodeData getModuleCode(String fullname) {
        String path = this.makeFilename(this.prefix, this.getSubname(fullname));
        if (path.length() < 0) {
            return null;
        }
        for (int i = 0; i < zip_searchorder.length; ++i) {
            SearchOrderEntry entry = zip_searchorder[i];
            String suffix = entry.suffix;
            String searchPath = path + suffix;
            Py.writeDebug("import", "# trying " + this.archive + File.separator + path);
            PyObject tocEntry = this.files.__finditem__(searchPath);
            if (tocEntry == null) continue;
            boolean ispackage = entry.type.contains((Object)EntryType.IS_PACKAGE);
            boolean isbytecode = entry.type.contains((Object)EntryType.IS_BYTECODE);
            if (isbytecode && this.isOutdatedBytecode(searchPath, tocEntry)) continue;
            String pathToEntry = this.archive + File.separator + searchPath;
            ZipBundle zipBundle = this.getDataStream(searchPath);
            byte[] codeBytes = isbytecode ? imp.readCode(fullname, zipBundle.inputStream, true) : imp.compileSource(fullname, zipBundle.inputStream, pathToEntry);
            zipBundle.close();
            if (codeBytes == null) continue;
            PyCode code = BytecodeLoader.makeCode(fullname + "$py", codeBytes, pathToEntry);
            return new ModuleCodeData(code, ispackage, pathToEntry);
        }
        return null;
    }

    private boolean isOutdatedBytecode(String path, PyObject tocEntry) {
        String sourcePath = path.substring(0, path.length() - 9) + ".py";
        PyObject sourceTocEntry = this.files.__finditem__(sourcePath);
        if (sourceTocEntry == null) {
            return false;
        }
        try {
            long bytecodeTime = this.dosTimeToEpoch(tocEntry.__finditem__(5).asInt(0), tocEntry.__finditem__(6).asInt(0));
            long sourceTime = this.dosTimeToEpoch(sourceTocEntry.__finditem__(5).asInt(0), sourceTocEntry.__finditem__(6).asInt(0));
            return bytecodeTime < sourceTime;
        }
        catch (PyObject.ConversionException ce) {
            return false;
        }
    }

    private PyObject readDirectory(String archive) {
        ZipFile zipFile;
        File file = new File(this.sys.getPath(archive));
        if (!file.canRead()) {
            throw zipimport.ZipImportError("can't open Zip file: '" + archive + "'");
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException ioe) {
            throw zipimport.ZipImportError("can't read Zip file: '" + archive + "'");
        }
        PyDictionary files = new PyDictionary();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String name = zipEntry.getName().replace('/', File.separatorChar);
            PyString __file__ = new PyString(archive + File.separator + name);
            PyInteger compress = new PyInteger(zipEntry.getMethod());
            PyLong data_size = new PyLong(zipEntry.getCompressedSize());
            PyLong file_size = new PyLong(zipEntry.getSize());
            PyInteger file_offset = new PyInteger(-1);
            PyInteger time = new PyInteger(this.epochToDosTime(zipEntry.getTime()));
            PyInteger date = new PyInteger(this.epochToDosDate(zipEntry.getTime()));
            PyLong crc = new PyLong(zipEntry.getCrc());
            PyTuple entry = new PyTuple(__file__, compress, data_size, file_size, file_offset, time, date, crc);
            ((PyObject)files).__setitem__(new PyString(name), (PyObject)entry);
        }
        try {
            zipFile.close();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        return files;
    }

    private String getSubname(String fullname) {
        int i = fullname.lastIndexOf(".");
        if (i >= 0) {
            return fullname.substring(i + 1);
        }
        return fullname;
    }

    private String makeFilename(String prefix, String name) {
        return prefix + name.replace('.', File.separatorChar);
    }

    private int epochToDosDate(long time) {
        Date d = new Date(time);
        int year = d.getYear() + 1900;
        if (year < 1980) {
            return 0x210000;
        }
        return year - 1980 << 9 | d.getMonth() + 1 << 5 | d.getDate() << 0;
    }

    private int epochToDosTime(long time) {
        Date d = new Date(time);
        return d.getHours() << 11 | d.getMinutes() << 5 | d.getSeconds() >> 1;
    }

    private long dosTimeToEpoch(int dosTime, int dosDate) {
        Date d = new Date((dosDate >> 9 & 0x7F) + 80, (dosDate >> 5 & 0xF) - 1, dosDate & 0x1F, dosTime >> 11 & 0x1F, dosTime >> 5 & 0x3F, (dosTime & 0x1F) * 2);
        return d.getTime();
    }

    public String toString() {
        return this.zipimporter_toString();
    }

    final String zipimporter_toString() {
        return "<zipimporter object \"" + this.archive + "\">";
    }

    static {
        PyType.addBuilder(zipimporter.class, new zipimporter$PyExposer());
        TYPE = PyType.fromClass(zipimporter.class);
        __doc__ = new PyString("zipimporter(archivepath) -> zipimporter object\n\nCreate a new zipimporter instance. 'archivepath' must be a path to\na zipfile. ZipImportError is raised if 'archivepath' doesn't point to\na valid Zip archive.");
        zip_searchorder = new SearchOrderEntry[]{new SearchOrderEntry(File.separator + "__init__$py.class", EnumSet.of(EntryType.IS_PACKAGE, EntryType.IS_BYTECODE)), new SearchOrderEntry(File.separator + "__init__.py", EnumSet.of(EntryType.IS_PACKAGE, EntryType.IS_SOURCE)), new SearchOrderEntry("$py.class", EnumSet.of(EntryType.IS_BYTECODE)), new SearchOrderEntry(".py", EnumSet.of(EntryType.IS_SOURCE))};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SearchOrderEntry {
        public String suffix;
        public EnumSet<EntryType> type;

        public SearchOrderEntry(String suffix, EnumSet<EntryType> type) {
            this.suffix = suffix;
            this.type = type;
        }
    }

    private class ZipBundle {
        ZipFile zipFile;
        InputStream inputStream;

        public ZipBundle(ZipFile zipFile, InputStream inputStream) {
            this.zipFile = zipFile;
            this.inputStream = inputStream;
        }

        public void close() {
            try {
                this.zipFile.close();
            }
            catch (IOException ioe) {
                throw Py.IOError(ioe);
            }
        }
    }

    private class ModuleCodeData {
        PyCode code;
        boolean ispackage;
        String path;

        public ModuleCodeData(PyCode code, boolean ispackage, String path) {
            this.code = code;
            this.ispackage = ispackage;
            this.path = path;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ModuleInfo {
        ERROR,
        NOT_FOUND,
        MODULE,
        PACKAGE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EntryType {
        IS_SOURCE,
        IS_BYTECODE,
        IS_PACKAGE;

    }
}

