/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.python.core.InternalTables;
import org.python.core.MakeProxies;
import org.python.core.Py;
import org.python.core.PyCompoundCallable;
import org.python.core.PyJavaClass;
import org.python.core.PyObject;
import org.python.core.PyReflectedField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyBeanEventProperty
extends PyReflectedField {
    public Method addMethod;
    public String eventName;
    public Class eventClass;
    public String __name__;
    private Field adapterField;
    private Class adapterClass;

    public PyBeanEventProperty(String eventName, Class eventClass, Method addMethod, Method eventMethod) {
        this.__name__ = eventMethod.getName().intern();
        this.addMethod = addMethod;
        this.eventName = eventName;
        this.eventClass = eventClass;
    }

    @Override
    public PyObject _doget(PyObject self) {
        Object field;
        if (self == null) {
            return this;
        }
        this.initAdapter();
        Object jself = Py.tojava(self, this.addMethod.getDeclaringClass());
        try {
            field = this.adapterField.get(this.getAdapter(jself));
        }
        catch (Exception exc) {
            throw Py.JavaError(exc);
        }
        if (field == null) {
            PyCompoundCallable func = new PyCompoundCallable();
            this.setFunction(jself, func);
            return func;
        }
        if (field instanceof PyCompoundCallable) {
            return (PyCompoundCallable)field;
        }
        PyCompoundCallable func = new PyCompoundCallable();
        this.setFunction(jself, func);
        func.append((PyObject)field);
        return func;
    }

    private static synchronized Class<?> getAdapterClass(Class<?> c) {
        InternalTables tbl = PyJavaClass.getInternalTables();
        Class o = tbl.getAdapterClass(c);
        if (o != null) {
            return o;
        }
        Class<?> pc = Py.findClass("org.python.proxies." + c.getName() + "$Adapter");
        if (pc == null) {
            pc = MakeProxies.makeAdapter(c);
        }
        tbl.putAdapterClass(c, pc);
        return pc;
    }

    private synchronized Object getAdapter(Object self) {
        String eventClassName;
        InternalTables tbl = PyJavaClass.getInternalTables();
        Object adapter = tbl.getAdapter(self, eventClassName = this.eventClass.getName());
        if (adapter != null) {
            return adapter;
        }
        try {
            adapter = this.adapterClass.newInstance();
            this.addMethod.invoke(self, adapter);
        }
        catch (Exception e) {
            throw Py.JavaError(e);
        }
        tbl.putAdapter(self, eventClassName, adapter);
        return adapter;
    }

    private void initAdapter() {
        if (this.adapterClass == null) {
            this.adapterClass = PyBeanEventProperty.getAdapterClass(this.eventClass);
        }
        if (this.adapterField == null) {
            try {
                this.adapterField = this.adapterClass.getField(this.__name__);
            }
            catch (NoSuchFieldException exc) {
                throw Py.AttributeError("Internal bean event error: " + this.__name__);
            }
        }
    }

    private void setFunction(Object self, PyObject callable) {
        this.initAdapter();
        try {
            this.adapterField.set(this.getAdapter(self), callable);
        }
        catch (Exception exc) {
            throw Py.JavaError(exc);
        }
    }

    @Override
    public boolean _doset(PyObject self, PyObject value) {
        Object jself = Py.tojava(self, this.addMethod.getDeclaringClass());
        if (!(value instanceof PyCompoundCallable)) {
            PyCompoundCallable func = new PyCompoundCallable();
            this.setFunction(jself, func);
            func.append(value);
        } else {
            this.setFunction(jself, value);
        }
        return true;
    }

    @Override
    public String toString() {
        return "<beanEventProperty " + this.__name__ + " for event " + this.eventClass.toString() + " " + Py.idstr(this) + ">";
    }
}

