/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.python.core.PyJavaClass;
import org.python.core.PySystemState;
import org.python.core.packagecache.PackageManager;

public class InternalTables {
    protected static final short JCLASS = 0;
    protected static final short LAZY_JCLASS = 1;
    protected static final short ADAPTER_CLASS = 2;
    protected static final short ADAPTER = 3;
    protected Map classes = new HashMap();
    protected Map temp = new HashMap();
    protected Map counters = new HashMap();
    protected Map lazyClasses = new HashMap();
    protected Map adapterClasses = new HashMap();
    protected final short GSTABLE = 1;
    protected final short JCSTABLE = (short)2;
    protected short keepstable;
    protected WeakHashMap adapters = new WeakHashMap();
    protected Iterator iter;
    protected Iterator grand;
    protected short iterType;
    protected Object cur;

    private static InternalTables tryImpl(String id) {
        try {
            if (id.indexOf(46) < 0) {
                if (id.charAt(id.length() - 1) == '>') {
                    id = InternalTables.makeCoreInternalTablesClass(id.substring(0, id.length() - 1));
                } else if (Character.isLowerCase(id.charAt(0))) {
                    id = InternalTables.makeCoreInternalTablesClass(id);
                }
            }
            return (InternalTables)Class.forName(id).newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static String makeCoreInternalTablesClass(String id) {
        if (Character.isLowerCase(id.charAt(0))) {
            id = Character.toUpperCase(id.charAt(0)) + id.substring(1);
        }
        return "org.python.core." + id + "InternalTables";
    }

    static InternalTables createInternalTables() {
        if (PySystemState.registry == null) {
            throw new IllegalStateException("Jython interpreter state not initialized. You need to call PySystemState.initialize or PythonInterpreter.initialize.");
        }
        String cands = PySystemState.registry.getProperty("python.options.internalTablesImpl");
        if (cands == null) {
            return new InternalTables();
        }
        StringTokenizer candEnum = new StringTokenizer(cands, ":");
        while (candEnum.hasMoreTokens()) {
            InternalTables tbl = InternalTables.tryImpl(candEnum.nextToken().trim());
            if (tbl == null) continue;
            return tbl;
        }
        return new InternalTables();
    }

    protected void commitTemp() {
        this.classes.putAll(this.temp);
        this.temp.clear();
    }

    protected Object getAdapter(Object o, String evc) {
        HashMap ads = (HashMap)this.adapters.get(o);
        if (ads == null) {
            return null;
        }
        WeakReference adw = (WeakReference)ads.get(evc);
        if (adw == null) {
            return null;
        }
        return adw.get();
    }

    protected void putAdapter(Object o, String evc, Object ad) {
        HashMap<String, WeakReference<Object>> ads = (HashMap<String, WeakReference<Object>>)this.adapters.get(o);
        if (ads == null) {
            ads = new HashMap<String, WeakReference<Object>>();
            this.adapters.put(o, ads);
        }
        ads.put(evc, new WeakReference<Object>(ad));
    }

    protected void beginStable(short lvl) {
        this.keepstable = lvl;
    }

    protected void endStable() {
        if (this.keepstable == this.JCSTABLE) {
            this.commitTemp();
        }
        this.keepstable = 0;
    }

    protected void classesPut(Class c, Object jc) {
        if (this.keepstable == this.JCSTABLE) {
            this.temp.put(c, jc);
        } else {
            this.classes.put(c, jc);
        }
        String name = c.getName();
        Integer cnt = (Integer)this.counters.get(name);
        if (cnt == null) {
            this.counters.put(name, new Integer(1));
            this.lazyClasses.remove(name);
        } else {
            this.counters.put(name, new Integer(cnt + 1));
        }
    }

    protected Object classesGet(Class c) {
        Object o = this.classes.get(c);
        if (o != null || this.keepstable != this.JCSTABLE) {
            return o;
        }
        return this.temp.get(c);
    }

    public void _beginCanonical() {
        this.beginStable(this.JCSTABLE);
        this.iter = this.classes.values().iterator();
        this.iterType = 0;
    }

    public void _beginLazyCanonical() {
        this.beginStable(this.GSTABLE);
        this.iter = this.lazyClasses.values().iterator();
        this.iterType = 1;
    }

    public void _beginOverAdapterClasses() {
        this.beginStable(this.GSTABLE);
        this.iter = this.adapterClasses.entrySet().iterator();
        this.iterType = (short)2;
    }

    public void _beginOverAdapters() {
        this.beginStable((short)0);
        this.grand = this.adapters.values().iterator();
        this.iter = null;
        this.iterType = (short)3;
    }

    public Object _next() {
        if (this.iterType == 3) {
            block12: {
                WeakReference adw;
                Object ad;
                do {
                    if (this.iter == null || !this.iter.hasNext()) {
                        if (this.grand.hasNext()) {
                            this.cur = this.grand.next();
                            this.iter = ((HashMap)this.cur).values().iterator();
                        } else {
                            this.iter = null;
                        }
                    }
                    if (this.iter == null) break block12;
                } while ((ad = (adw = (WeakReference)this.iter.next()).get()) == null);
                return ad.getClass().getInterfaces()[0];
            }
            this.grand = null;
        } else if (this.iter.hasNext()) {
            this.cur = this.iter.next();
            switch (this.iterType) {
                case 0: {
                    return this.cur;
                }
                case 1: {
                    PyJavaClass lazy = (PyJavaClass)this.cur;
                    return new _LazyRep(lazy.__name__, lazy.__mgr__);
                }
                case 2: {
                    Map.Entry entry = (Map.Entry)this.cur;
                    return entry.getKey();
                }
            }
        }
        this.cur = null;
        this.endStable();
        this.iter = null;
        return null;
    }

    public void _flushCurrent() {
        this.iter.remove();
        switch (this.iterType) {
            case 0: {
                this.classesDec(((PyJavaClass)this.cur).__name__);
                break;
            }
            case 3: {
                if (((HashMap)this.cur).size() != 0) break;
                this.grand.remove();
            }
        }
    }

    public void _flush(PyJavaClass jc) {
        Class c = jc.proxyClass;
        if (c == null) {
            this.lazyClasses.remove(jc.__name__);
        } else {
            this.classes.remove(c);
            this.classesDec(jc.__name__);
        }
    }

    protected Class getAdapterClass(Class c) {
        return (Class)this.adapterClasses.get(c);
    }

    protected PyJavaClass getCanonical(Class c) {
        return (PyJavaClass)this.classesGet(c);
    }

    protected PyJavaClass getLazyCanonical(String name) {
        return (PyJavaClass)this.lazyClasses.get(name);
    }

    protected void putAdapterClass(Class c, Class ac) {
        this.adapterClasses.put(c, ac);
    }

    protected void putCanonical(Class c, PyJavaClass canonical) {
        this.classesPut(c, canonical);
    }

    protected void putLazyCanonical(String name, PyJavaClass canonical) {
        this.lazyClasses.put(name, canonical);
    }

    protected boolean queryCanonical(String name) {
        return this.counters.get(name) != null || this.lazyClasses.get(name) != null;
    }

    protected void classesDec(String name) {
        int c = (Integer)this.counters.get(name);
        if (c == 1) {
            this.counters.remove(name);
        } else {
            this.counters.put(name, new Integer(c - 1));
        }
    }

    public static class _LazyRep {
        public String name;
        public PackageManager mgr;

        _LazyRep(String name, PackageManager mgr) {
            this.name = name;
            this.mgr = mgr;
        }
    }
}

