/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Delete
extends SvnCommand {
    private String message = null;
    private SVNUrl url = null;
    private File file = null;
    private File dir = null;
    private boolean force = false;
    private Vector filesets = new Vector();
    private ISVNClientAdapter svnClient;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.svnClient = iSVNClientAdapter;
        this.validateAttributes();
        this.log("Svn : Delete");
        if (this.url != null) {
            this.deleteUrl(this.url, this.message);
        }
        if (this.file != null) {
            this.deleteFile(this.file, this.force);
        }
        if (this.dir != null) {
            this.deleteFile(this.dir, this.force);
        }
        if (this.filesets.size() > 0) {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(i);
                this.deleteFileSet(fileSet);
            }
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.url != null && this.message == null) {
            throw new BuildException("Message attribute must be set when using url attribute");
        }
    }

    private void deleteUrl(SVNUrl sVNUrl, String string) throws BuildException {
        try {
            this.svnClient.remove(new SVNUrl[]{sVNUrl}, string);
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Cannot delete url " + sVNUrl.toString(), (Throwable)sVNClientException);
        }
    }

    private void deleteFile(File file, boolean bl) throws BuildException {
        try {
            this.svnClient.remove(new File[]{file}, bl);
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Cannot delete file or directory " + file.getAbsolutePath(), (Throwable)sVNClientException);
        }
    }

    private void deleteFileSet(FileSet fileSet) throws BuildException {
        int n;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file = fileSet.getDir(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        String[] stringArray2 = directoryScanner.getIncludedDirectories();
        File[] fileArray = new File[stringArray.length + stringArray2.length];
        int n2 = 0;
        for (n = 0; n < stringArray2.length; ++n) {
            fileArray[n2] = new File(file, stringArray2[n]);
            ++n2;
        }
        for (n = 0; n < stringArray.length; ++n) {
            fileArray[n2] = new File(file, stringArray[n]);
            ++n2;
        }
        try {
            this.svnClient.remove(fileArray, this.force);
        }
        catch (SVNClientException sVNClientException) {
            this.log("Cannot delete file " + this.file.getAbsolutePath());
        }
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }
}

