/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public abstract class SVNNotificationHandler {
    protected List notifylisteners = new ArrayList();
    protected int command;
    protected boolean logEnabled = true;
    protected File baseDir = new File(".");

    public void add(ISVNNotifyListener iSVNNotifyListener) {
        this.notifylisteners.add(iSVNNotifyListener);
    }

    public void remove(ISVNNotifyListener iSVNNotifyListener) {
        this.notifylisteners.remove(iSVNNotifyListener);
    }

    public void enableLog() {
        this.logEnabled = true;
    }

    public void disableLog() {
        this.logEnabled = false;
    }

    public void logMessage(String string) {
        if (this.logEnabled) {
            Iterator iterator = this.notifylisteners.iterator();
            while (iterator.hasNext()) {
                ISVNNotifyListener iSVNNotifyListener = (ISVNNotifyListener)iterator.next();
                iSVNNotifyListener.logMessage(string);
            }
        }
    }

    public void logError(String string) {
        Iterator iterator = this.notifylisteners.iterator();
        while (iterator.hasNext()) {
            ISVNNotifyListener iSVNNotifyListener = (ISVNNotifyListener)iterator.next();
            iSVNNotifyListener.logError(string);
        }
    }

    public void logRevision(long l, String string) {
        if (this.logEnabled) {
            Iterator iterator = this.notifylisteners.iterator();
            while (iterator.hasNext()) {
                ISVNNotifyListener iSVNNotifyListener = (ISVNNotifyListener)iterator.next();
                iSVNNotifyListener.logRevision(l, string);
            }
        }
    }

    public void logCompleted(String string) {
        if (this.logEnabled) {
            Iterator iterator = this.notifylisteners.iterator();
            while (iterator.hasNext()) {
                ISVNNotifyListener iSVNNotifyListener = (ISVNNotifyListener)iterator.next();
                iSVNNotifyListener.logCompleted(string);
            }
        }
    }

    public void setCommand(int n) {
        this.command = n;
        Iterator iterator = this.notifylisteners.iterator();
        while (iterator.hasNext()) {
            ISVNNotifyListener iSVNNotifyListener = (ISVNNotifyListener)iterator.next();
            iSVNNotifyListener.setCommand(n);
        }
    }

    public void logCommandLine(String string) {
        if (this.logEnabled && !this.skipCommand()) {
            Iterator iterator = this.notifylisteners.iterator();
            while (iterator.hasNext()) {
                ISVNNotifyListener iSVNNotifyListener = (ISVNNotifyListener)iterator.next();
                iSVNNotifyListener.logCommandLine(string);
            }
        }
    }

    public void logException(Exception exception) {
        for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
            this.logError(throwable.getMessage());
        }
    }

    public void setBaseDir(File file) {
        this.baseDir = file;
    }

    public void setBaseDir() {
        this.baseDir = new File(".");
    }

    private File getAbsoluteFile(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.baseDir, string);
        }
        return file;
    }

    public void notifyListenersOfChange(String string) {
        if (string == null) {
            return;
        }
        File file = this.getAbsoluteFile(string);
        if (file == null) {
            this.logMessage("Warning : invalid path :" + string);
            return;
        }
        SVNNodeKind sVNNodeKind = file.isFile() ? SVNNodeKind.FILE : (file.isDirectory() ? SVNNodeKind.DIR : SVNNodeKind.UNKNOWN);
        Iterator iterator = this.notifylisteners.iterator();
        while (iterator.hasNext()) {
            ISVNNotifyListener iSVNNotifyListener = (ISVNNotifyListener)iterator.next();
            iSVNNotifyListener.onNotify(file, sVNNodeKind);
        }
    }

    public void notifyListenersOfChange(String string, SVNNodeKind sVNNodeKind) {
        if (string == null) {
            return;
        }
        File file = this.getAbsoluteFile(string);
        if (file == null) {
            this.logMessage("Warning : invalid path :" + string);
            return;
        }
        Iterator iterator = this.notifylisteners.iterator();
        while (iterator.hasNext()) {
            ISVNNotifyListener iSVNNotifyListener = (ISVNNotifyListener)iterator.next();
            iSVNNotifyListener.onNotify(file, sVNNodeKind);
        }
    }

    protected boolean skipCommand() {
        return this.command == 18 || this.command == 19 || this.command == 13 || this.command == 11 || this.command == 20 || this.command == 21 || this.command == 12;
    }
}

