/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.ErrorManager;

public abstract class Message {
    public StringTemplate msgST;
    public StringTemplate locationST;
    public StringTemplate reportST;
    public StringTemplate messageFormatST;
    public int msgID;
    public Object arg;
    public Object arg2;
    public Throwable e;
    public String file;
    public int line = -1;
    public int column = -1;

    public Message() {
    }

    public Message(int n) {
        this(n, null, null);
    }

    public Message(int n, Object object, Object object2) {
        this.setMessageID(n);
        this.arg = object;
        this.arg2 = object2;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public void setMessageID(int n) {
        this.msgID = n;
        this.msgST = ErrorManager.getMessage(n);
    }

    public StringTemplate getMessageTemplate() {
        return this.msgST.getInstanceOf();
    }

    public StringTemplate getLocationTemplate() {
        return this.locationST.getInstanceOf();
    }

    public String toString(StringTemplate stringTemplate) {
        this.locationST = ErrorManager.getLocationFormat();
        this.reportST = ErrorManager.getReportFormat();
        this.messageFormatST = ErrorManager.getMessageFormat();
        boolean bl = false;
        if (this.line != -1) {
            this.locationST.setAttribute("line", this.line);
            bl = true;
        }
        if (this.column != -1) {
            this.locationST.setAttribute("column", this.column);
            bl = true;
        }
        if (this.file != null) {
            this.locationST.setAttribute("file", this.file);
            bl = true;
        }
        this.messageFormatST.setAttribute("id", this.msgID);
        this.messageFormatST.setAttribute("text", stringTemplate);
        if (bl) {
            this.reportST.setAttribute("location", this.locationST);
        }
        this.reportST.setAttribute("message", this.messageFormatST);
        this.reportST.setAttribute("type", ErrorManager.getMessageType(this.msgID));
        return this.reportST.toString();
    }
}

