% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TextOperators.R
\name{ContainsWordsOperator}
\alias{ContainsWordsOperator}
\title{Create a Contains Words Search Operator}
\usage{
ContainsWordsOperator(attribute, value)
}
\arguments{
\item{attribute}{The attribute to be evaluated. This should be the text field within the RCSB PDB
that you want to search against.}

\item{value}{The words to search for in the attribute. This can be a single word or a set of words,
and the search will return entries containing any of these words in the specified attribute.}
}
\value{
An object of class `ContainsWordsOperator` that can be used in search queries to retrieve entries
        where the attribute contains the specified words.
}
\description{
Constructs a `ContainsWordsOperator` object for search operations that look for attributes containing specific words.
This operator is particularly useful for text-based searches where the goal is to find entries that include
particular keywords or phrases within a specified attribute.
}
\examples{
# Search for entries containing specific words in an attribute
operator <- ContainsWordsOperator(attribute = "rcsb_primary_citation.title",
                                  value = "crystal structure")
print(operator)
}
