% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_processing.R
\name{convert}
\alias{convert}
\title{Pre-process data for Midas imputation}
\usage{
convert(data, bin_cols, cat_cols, minmax_scale = FALSE)
}
\arguments{
\item{data}{Either an object of class \code{data.frame}, \code{data.table}, or a path to a regular, delimited file}

\item{bin_cols, cat_cols}{A vector, column names corresponding to binary and categorical variables respectively}

\item{minmax_scale}{Boolean, indicating whether to scale all numeric columns between 0 and 1, to improve model convergence}
}
\value{
Returns custom S3 object of class `midas_preproc' containing:
\itemize{
\item \code{data} -- processed version of input data,
\item \code{bin_list} -- vector of binary variable names
\item \code{cat_lists} -- embedded list of one-hot encoded categorical variable names
\item \code{minmax_params} -- list of min. and max. values for each numeric object scaled
}

List containing converted data, categorical and binary labels to be imported into the imputation model, and scaling parameters for post-imputation transformations.
}
\description{
\code{convert} pre-processes datasets to enable user-friendly interface with the main \code{train()} function.
}
\details{
The function has two advantages over manual pre-processing:
\enumerate{
\item Utilises data.table for fast read-in and processing of large datasets
\item Outputs an object that can be passed directly to \code{train()} without re-specifying column names etc.
}
}
\examples{
data = data.frame(a = sample(c("red","yellow","blue",NA),100, replace = TRUE),
                  b = 1:100,
                  c = sample(c("YES","NO",NA),100,replace = TRUE),
                  d = runif(100),
                  e = sample(c("YES","NO"), 100, replace = TRUE),
                  f = sample(c("male","female","trans","other",NA), 100, replace = TRUE),
                  stringsAsFactors = FALSE)

bin <- c("c","e")
cat <- c("a","f")

convert(data, bin_cols = bin, cat_cols = cat)
}
\keyword{preprocessing}
