% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.matrix.R
\name{msc.matrix}
\alias{msc.matrix}
\title{Build cluster matrix}
\usage{
msc.matrix(files, samples, groups)
}
\arguments{
\item{files}{a character vector containing the uc file names (output of the VSEARCH tool) e.g. all.minicircles.circ.id70.uc, all.minicircles.circ.id80.uc...}

\item{samples}{a character vector containing the sample names. The vector should be order alphabetically.}

\item{groups}{a vector, of equal length as samples, specifying to which group (e.g. species) the samples belong to.}
}
\value{
a list containing one cluster matrix per percent identity. The value 0 in the cluster matrix means the MSC doesn't occur in the sample. A value higher than 0 means the MSC is found at least once in the sample.
}
\description{
Clustering based on a percent identity, performed with the VSEARCH tool, will generate files in uc format.
The msc.matrix function will transform every input file into a cluster matrix.
The columns of the matrix correspond to the samples and the rows of the matrix correspond to the minicircle sequence cluster (MSC).
The absence of a MSC in a sample is indicated with the value of zero while the presence of a MSC in a sample will be indicated with a value >= 1.
}
\examples{
data(exData)

### run function
\donttest{
matrices <- msc.matrix(files = system.file("extdata", exData$ucs, package="rKOMICS"), 
                      samples = sort(exData$samples), 
                      groups = exData$species[order(exData$samples)])
}

### or: 
data(matrices)

### show matrix with id 95\%
matrices[["id95"]]
rowSums(matrices[["id95"]]) # --> frequency of MSC across all samples
colSums(matrices[["id95"]]) # --> number of MSC per sample

}
