% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipLevel1BGeo.R
\name{clipLevel1BGeoGeometry}
\alias{clipLevel1BGeoGeometry}
\title{Clip GEDI Full Waveform Geolocations by geometry}
\usage{
clipLevel1BGeoGeometry(level1BGeo, polygon_spdf, split_by)
}
\arguments{
\item{level1BGeo}{A GEDI Level1b object (output of \code{\link[rGEDI:readLevel1B]{readLevel1B}} function).
An S4 object of class "data.table".}

\item{polygon_spdf}{Polygon. An object of class \code{\link[sp]{SpatialPolygonsDataFrame-class}},
which can be loaded as an ESRI shapefile using \code{\link[raster:shapefile]{raster::shapefile()}} function in the \emph{raster} package.}

\item{split_by}{Polygon id. If defined, GEDI data will be clipped by each polygon using the polygon id from table of attribute defined by the user.}
}
\value{
Returns an S4 object of class \code{\link[data.table:data.table]{data.table-class}} containing the
clipped GEDI level1B extracted geolocations.
}
\description{
This function clips GEDI level1B extracted geolocation (level1BGeo)
data within a given geometry
}
\examples{
# Specifying the path to GEDI level1B data (zip file)
outdir = tempdir()
level1B_fp_zip <- system.file("extdata",
                  "GEDI01_B_2019108080338_O01964_T05337_02_003_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level1B data
level1Bpath <- unzip(level1B_fp_zip,exdir = outdir)

# Reading GEDI level1B data (h5 file)
level1b<-readLevel1B(level1Bpath=level1Bpath)

# Extracting GEDI Full Waveform Geolocations
level1bGeo<-getLevel1BGeo(level1b)

# Specifying the path to shapefile
polygon_filepath <- system.file("extdata", "stands_cerrado.shp", package="rGEDI")

# Reading shapefile as SpatialPolygonsDataFrame object
library(raster)
polygon_spdf<-shapefile(polygon_filepath)

# Clipping GEDI Full Waveform Geolocations by Geometry
level1bGeo_clip = clipLevel1BGeoGeometry(level1bGeo, polygon_spdf, split_by="id")

library(leaflet)
leaflet() \%>\%
 addCircleMarkers(level1bGeo_clip$longitude_bin0,
                  level1bGeo_clip$latitude_bin0,
                  radius = 1,
                  opacity = 1,
                  color = "red")  \%>\%
 addScaleBar(options = list(imperial = FALSE)) \%>\%
 addPolygons(data=polygon_spdf,weight=1,col = 'white',
             opacity = 1, fillOpacity = 0) \%>\%
 addProviderTiles(providers$Esri.WorldImagery)

close(level1b)
}
\seealso{
https://lpdaac.usgs.gov/products/gedi01_bv001/
}
