% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.group.R
\name{ena.group}
\alias{ena.group}
\title{Compute summary statistic for groupings of units using given method (typically, mean)}
\usage{
ena.group(enaset = NULL, by = NULL, method = mean)
}
\arguments{
\item{enaset}{An \code{\link{ENAset}} or a vector of values to group.}

\item{by}{A vector of values the same length as units. Uses rotated points for group positions and normed data to get the group edge weights}

\item{method}{A function that is used on grouped points. Default: mean().  If `enaset` is an ENAset, enaset$points.rotated will be groups using `mean` regardless of `method` provided}
}
\value{
A list containing names, points, and edge weights for each of the unique groups formed by the function
}
\description{
Computes summary statistics for groupings (given as vector) of units in ena data using given method (typically, mean); computes summary statistic for point locations and edge weights for each grouping
}
\examples{
data(RS.data)

codeNames = c('Data','Technical.Constraints','Performance.Parameters',
  'Client.and.Consultant.Requests','Design.Reasoning','Collaboration');

accum = ena.accumulate.data(
  units = RS.data[,c("UserName","Condition")],
  conversation = RS.data[,c("Condition","GroupName")],
  metadata = RS.data[,c("CONFIDENCE.Change","CONFIDENCE.Pre","CONFIDENCE.Post")],
  codes = RS.data[,codeNames],
  window.size.back = 4
)

set = ena.make.set(
  enadata = accum
)

means = ena.group(set, by=accum$metadata$Condition)


}
