/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.test.IntegrationTest;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.util.ReflectionTestUtils;

class MergedContextConfigurationProperties {
    private final MergedContextConfiguration configuration;

    public MergedContextConfigurationProperties(MergedContextConfiguration configuration) {
        this.configuration = configuration;
    }

    public void add(String[] properties, String ... additional) {
        LinkedHashSet<String> merged = new LinkedHashSet<String>(Arrays.asList(this.configuration.getPropertySourceProperties()));
        merged.addAll(Arrays.asList(properties));
        merged.addAll(Arrays.asList(additional));
        this.addIntegrationTestProperty(merged);
        ReflectionTestUtils.setField((Object)this.configuration, (String)"propertySourceProperties", (Object)merged.toArray(new String[merged.size()]));
    }

    private void addIntegrationTestProperty(Set<String> propertySourceProperties) {
        propertySourceProperties.add(IntegrationTest.class.getName() + "=true");
    }
}

