/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.transit.RouteInfo;
import com.conveyal.r5.transit.TransitLayer;
import com.conveyal.r5.transit.TransportNetwork;
import com.conveyal.r5.transit.TripPattern;
import org.ipea.r5r.RDataFrame;
import org.locationtech.jts.geom.Coordinate;

public class TransitNetwork {
    public RDataFrame routesTable;
    public RDataFrame stopsTable;

    public TransitNetwork(TransportNetwork transportNetwork) {
        this.buildRoutesTable(transportNetwork);
        this.buildStopsTable(transportNetwork);
    }

    private void buildStopsTable(TransportNetwork transportNetwork) {
        this.stopsTable = new RDataFrame();
        this.stopsTable.addIntegerColumn("stop_index", -1);
        this.stopsTable.addStringColumn("stop_id", "");
        this.stopsTable.addStringColumn("stop_name", "");
        this.stopsTable.addDoubleColumn("lat", -1.0);
        this.stopsTable.addDoubleColumn("lon", -1.0);
        this.stopsTable.addBooleanColumn("linked_to_street", false);
        for (int stopIndex = 0; stopIndex < transportNetwork.transitLayer.getStopCount(); ++stopIndex) {
            Coordinate coordinate;
            this.stopsTable.append();
            this.stopsTable.set("stop_index", stopIndex);
            this.stopsTable.set("stop_id", (String)transportNetwork.transitLayer.stopIdForIndex.get(stopIndex));
            if (transportNetwork.transitLayer.stopNames != null) {
                this.stopsTable.set("stop_name", (String)transportNetwork.transitLayer.stopNames.get(stopIndex));
            }
            if ((coordinate = transportNetwork.transitLayer.getCoordinateForStopFixed(stopIndex)) != null) {
                Double lat = coordinate.y / 1.0E7;
                Double lon = coordinate.x / 1.0E7;
                this.stopsTable.set("lat", lat);
                this.stopsTable.set("lon", lon);
            }
            boolean linkedToStreet = transportNetwork.transitLayer.streetVertexForStop.get(stopIndex) != -1;
            this.stopsTable.set("linked_to_street", linkedToStreet);
        }
    }

    private void buildRoutesTable(TransportNetwork transportNetwork) {
        this.routesTable = new RDataFrame();
        this.routesTable.addStringColumn("agency_id", "");
        this.routesTable.addStringColumn("agency_name", "");
        this.routesTable.addStringColumn("route_id", "");
        this.routesTable.addStringColumn("long_name", "");
        this.routesTable.addStringColumn("short_name", "");
        this.routesTable.addStringColumn("mode", "");
        this.routesTable.addStringColumn("geometry", "");
        for (TripPattern pattern : transportNetwork.transitLayer.tripPatterns) {
            RouteInfo route = (RouteInfo)transportNetwork.transitLayer.routes.get(pattern.routeIndex);
            this.routesTable.append();
            this.routesTable.set("agency_id", route.agency_id);
            this.routesTable.set("agency_name", route.agency_name);
            this.routesTable.set("route_id", route.route_id);
            this.routesTable.set("long_name", route.route_long_name);
            this.routesTable.set("short_name", route.route_short_name);
            this.routesTable.set("mode", TransitLayer.getTransitModes((int)route.route_type).toString());
            if (pattern.shape != null) {
                this.routesTable.set("geometry", pattern.shape.toString());
                continue;
            }
            StringBuilder geometry = new StringBuilder();
            for (int stopIndex : pattern.stops) {
                Coordinate coordinate = transportNetwork.transitLayer.getCoordinateForStopFixed(stopIndex);
                if (coordinate == null) continue;
                coordinate.x /= 1.0E7;
                coordinate.y /= 1.0E7;
                if (geometry.toString().equals("")) {
                    geometry.append("LINESTRING (").append(coordinate.x).append(" ").append(coordinate.y);
                    continue;
                }
                geometry.append(", ").append(coordinate.x).append(" ").append(coordinate.y);
            }
            if (!geometry.toString().equals("")) {
                geometry.append(")");
            }
            this.routesTable.set("geometry", geometry.toString());
        }
    }
}

