/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.analyst.scenario.Scenario;
import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.api.util.TransitModes;
import com.conveyal.r5.transit.TransportNetwork;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.ipea.r5r.RoutingProperties;
import org.ipea.r5r.Utils.Utils;

public abstract class R5Process {
    protected final ForkJoinPool r5rThreadPool;
    protected final TransportNetwork transportNetwork;
    protected final RoutingProperties routingProperties;
    protected String[] fromIds;
    protected double[] fromLats;
    protected double[] fromLons;
    protected int nOrigins;
    protected EnumSet<LegMode> directModes;
    protected EnumSet<TransitModes> transitModes;
    protected EnumSet<LegMode> accessModes;
    protected EnumSet<LegMode> egressModes;
    protected String departureDate;
    protected String departureTime;
    protected int maxWalkTime;
    protected int maxBikeTime;
    protected int maxTripDuration;

    public R5Process(ForkJoinPool threadPool, TransportNetwork transportNetwork, RoutingProperties routingProperties) {
        this.r5rThreadPool = threadPool;
        this.transportNetwork = transportNetwork;
        this.routingProperties = routingProperties;
    }

    public void setOrigins(String[] fromIds, double[] fromLats, double[] fromLons) {
        this.fromIds = fromIds;
        this.fromLats = fromLats;
        this.fromLons = fromLons;
        this.nOrigins = fromIds.length;
    }

    public void setModes(String directModes, String accessModes, String transitModes, String egressModes) {
        this.directModes = Utils.setLegModes(directModes);
        this.accessModes = Utils.setLegModes(accessModes);
        this.egressModes = Utils.setLegModes(egressModes);
        this.transitModes = Utils.setTransitModes(transitModes);
    }

    public void setDepartureDateTime(String departureDate, String departureTime) {
        this.departureDate = departureDate;
        this.departureTime = departureTime;
    }

    public void setTripDuration(int maxWalkTime, int maxBikeTime, int maxTripDuration) {
        this.maxWalkTime = maxWalkTime;
        this.maxBikeTime = maxBikeTime;
        this.maxTripDuration = maxTripDuration;
    }

    public List<LinkedHashMap<String, ArrayList<Object>>> run() throws ExecutionException, InterruptedException {
        int[] requestIndices = new int[this.nOrigins];
        for (int i = 0; i < this.nOrigins; ++i) {
            requestIndices[i] = i;
        }
        AtomicInteger totalProcessed = new AtomicInteger(1);
        List processResults = (List)((ForkJoinTask)this.r5rThreadPool.submit(() -> Arrays.stream(requestIndices).parallel().mapToObj(index -> {
            LinkedHashMap<String, ArrayList<Object>> results = null;
            try {
                results = this.runProcess(index);
                if (!Utils.verbose) {
                    System.out.print("\r" + totalProcessed.getAndIncrement() + " out of " + this.nOrigins + " origins processed.                 ");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return results;
        }).collect(Collectors.toList()))).get();
        System.out.println("\n");
        return processResults;
    }

    protected abstract LinkedHashMap<String, ArrayList<Object>> runProcess(int var1) throws ParseException;

    protected RegionalTask buildRequest(int index) throws ParseException {
        int secondsFromMidnight;
        RegionalTask request = new RegionalTask();
        request.scenario = new Scenario();
        request.scenarioId = request.scenario.id = "id";
        request.zoneId = this.transportNetwork.getTimeZone();
        request.fromLat = this.fromLats[index];
        request.fromLon = this.fromLons[index];
        request.walkSpeed = (float)this.routingProperties.walkSpeed;
        request.bikeSpeed = (float)this.routingProperties.bikeSpeed;
        request.streetTime = this.maxTripDuration;
        request.maxWalkTime = this.maxWalkTime;
        request.maxBikeTime = this.maxBikeTime;
        request.maxCarTime = this.maxTripDuration;
        request.maxTripDurationMinutes = this.maxTripDuration;
        request.makeTauiSite = false;
        request.recordTimes = true;
        request.recordAccessibility = false;
        request.maxRides = this.routingProperties.maxRides;
        request.bikeTrafficStress = this.routingProperties.maxLevelTrafficStress;
        request.directModes = this.directModes;
        request.accessModes = this.accessModes;
        request.egressModes = this.egressModes;
        request.transitModes = this.transitModes;
        request.date = LocalDate.parse(this.departureDate);
        request.fromTime = secondsFromMidnight = Utils.getSecondsFromMidnight(this.departureTime);
        request.toTime = secondsFromMidnight + this.routingProperties.timeWindowSize * 60;
        request.monteCarloDraws = this.routingProperties.numberOfMonteCarloDraws;
        request.percentiles = this.routingProperties.percentiles;
        return request;
    }
}

