% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_readforecast.R
\name{SS_readforecast}
\alias{SS_readforecast}
\title{read forecast file}
\usage{
SS_readforecast(file = "forecast.ss", Nfleets, Nareas, nseas,
  version = "3.30", readAll = FALSE, verbose = TRUE)
}
\arguments{
\item{file}{Filename either with full path or relative to working directory.}

\item{Nfleets}{Number of fleets (not required in 3.30).}

\item{Nareas}{Number of areas (not required in 3.30).}

\item{nseas}{number of seasons (not required in 3.30).}

\item{version}{SS version number. Currently only "3.24" or "3.30" are supported,
either as character or numeric values (noting that numeric 3.30  = 3.3).}

\item{readAll}{Should the function continue even if Forecast=0
(at which point SS stops reading)}

\item{verbose}{Should there be verbose output while running the file?}
}
\description{
read Stock Synthesis forecast file into list object in R
}
\seealso{
\code{\link{SS_readstarter}}, \code{\link{SS_readdat}},
\code{\link{SS_writestarter}},
\code{\link{SS_writeforecast}}, \code{\link{SS_writedat}},
}
\author{
Ian Taylor
}
