% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_beta_var.r
\name{r2_beta_var}
\alias{r2_beta_var}
\title{r2_beta_var}
\usage{
r2_beta_var(dat, v1, v2, nv)
}
\arguments{
\item{dat}{N by (M+1) matrix having variables in the order of cbind(y,x)}

\item{v1}{This can be set as v1=1, v1=2, v1=3  or any value between 1 - M based on combination}

\item{v2}{This can be set as v2=1, v2=2, v2=3, or any value between 1 - M based on combination}

\item{nv}{Sample size}
}
\value{
This function will estiamte the variance of beta1^2 and beta2^2, and the covariance between beta1^2 and beta2^2, i.e. the information matrix of squared regression coefficients. beta1 and beta2 are regression coefficients from a multiple regression model, i.e. y = x1 * beta1 + x2 * beta2 +e, where y, x1 and x2 are column-standardised. The outputs are listed as follows.
\item{beta1_sq}{beta1_sq}
\item{beta2_sq}{beta2_sq}
\item{var1}{Variance of beta1_sq}
\item{var2}{Variance of beta2_sq}
\item{var1_2}{Variance of difference between beta1_sq and beta2_sq}
\item{cov}{Covariance between beta1_sq and beta2_sq}
\item{upper_beta1_sq}{upper limit of 95\% CI for beta1_sq}
\item{lower_beta1_sq}{lower limit of 95\% CI for beta1_sq}
\item{upper_beta2_sq}{upper limit of 95\% CI for beta2_sq}
\item{lower_beta2_sq}{lower limit of 95\% CI for beta2_sq}
}
\description{
This function estimates var(beta1^2) and (beta2^2), and
beta1 and 2 are regression coefficients from a multiple regression model,
i.e. y = x1 * beta1 + x2 * beta2 +e, y, x1 and x2 are column-standardised
(see Olkin and Finn 1995).
y is N by 1 matrix having the dependent variable,
x1 is N by 1 matrix having the ith explanatory variable.
x2 is N by 1 matrix having the jth explanatory variable.
v1 and v2 indicates the ith and jth column in the data
(v1 or v2 should be a single interger between 1 - M, see Arguments below).
}
\examples{
#To get the 95\% CI of beta1_sq and beta2_sq
#beta1 and beta2 are regression coefficients from a multiple regression model,
#i.e. y = x1 * beta1 + x2 * beta2 +e, where y, x1 and x2 are column-standardised.

dat=dat2
nv=length(dat$V1)
v1=c(1)
v2=c(2)
output=r2_beta_var(dat,v1,v2,nv)
output
#r2redux output
#output$beta1_sq (beta1_sq)
#0.01118301

#output$beta2_sq (beta2_sq)
#0.004980285

#output$var1 (variance of beta1_sq)
#7.072931e-05

#output$var2 (variance of beta2_sq)
#3.161929e-05

#output$var1_2 (variance of difference between beta1_sq and beta2_sq)
#0.000162113

#output$cov (covariance between beta1_sq and beta2_sq)
#-2.988221e-05

#output$upper_beta1_sq (upper limit of 95\% CI for beta1_sq)
#0.03037793

#output$lower_beta1_sq (lower limit of 95\% CI for beta1_sq)
#-0.00123582

#output$upper_beta2_sq (upper limit of 95\% CI for beta2_sq)
#0.02490076

#output$lower_beta2_sq (lower limit of 95\% CI for beta2_sq)
#-0.005127546
}
\references{
Olkin, I. and Finn, J.D. Correlations redux. Psychological Bulletin, 1995. 118(1): p. 155.
}
\keyword{a}
\keyword{beta^2}
\keyword{from}
\keyword{multiple}
\keyword{of}
\keyword{regression}
\keyword{variance}
