% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bool.R
\name{as.boolean}
\alias{as.boolean}
\title{Convert boolean values between formats}
\usage{
as.boolean(ds, type = 3)
}
\arguments{
\item{ds}{item to convert}

\item{type}{format to convert to, choices 1, 2 or 3}
}
\value{
output adhering to the format of the type provided
}
\description{
Convert Yes/No to 1/0 or to TRUE/FALSE or vice versa
}
\details{
Output various format of booleans into a specified format. Below are the options for the type argument.

\strong{type}: options are as follows - \cr\cr
     1 - Yes/No \cr
     2 - TRUE/FALSE\cr
     3 - 1/0\cr
}
\examples{

# Task: convert "yes" or "no" to format of TRUE or FALSE
as.boolean("yes",2)
as.boolean("no",2)
as.boolean("YES",2)
as.boolean("NO",2)

# Task: convert "yes" or "no" to format of 1 or 0
as.boolean("yes",3)
as.boolean("no",3)
as.boolean("YES",3)
as.boolean("NO",3)


# Task: convert 1 to format of Yes or No
as.boolean(1,1)

# Task: convert "T" to format of Yes or No
as.boolean("T",1)


# Task: convert "f" to format of TRUE or FALSE
as.boolean("f",2)


# Task: convert 1 to format of TRUE or FALSE
as.boolean(1,2)


# Task: convert "Y" or "y" to format of Yes or No
as.boolean("Y",1) #uppercase Y
as.boolean("y",1) #lowercase y


# Task: convert TRUE/FALSE to format of 1 or 0
as.boolean(TRUE,3)
as.boolean(FALSE,3)


# Task: convert TRUE/FALSE to format of Yes or No
as.boolean(TRUE,1)
as.boolean(FALSE,1)



# In case of error in argument
# as.boolean("tr",3) #NA
# as.boolean("ye",3) #NA

# vector of mixed boolean to TRUE/FALSE or 1/0
multv <- c(TRUE,"y","n","YES","yes",FALSE,"f","F","T","t")
as.boolean(multv,1) # return vector as Yes/No
as.boolean(multv,2) # return vector as TRUE/FALSE
as.boolean(multv,3) # return vector as 1/0

}
