% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDate.R
\name{getDate}
\alias{getDate}
\title{Extract all dates from a string}
\usage{
getDate(str1, out.format = "\%Y-\%m-\%d")
}
\arguments{
\item{str1}{string to parse}

\item{out.format}{date output format}
}
\description{
Extract all dates from a string
}
\note{
\strong{DATE FORMATS IN R}\cr
\tabular{rrrrr}{
\strong{Date Specification}   \tab \tab \strong{Description}          \tab \tab  \strong{Example} \cr
\%a  \tab \tab Abbreviated weekday             \tab \tab Sun, Thu \cr
\%A  \tab \tab Full weekday                    \tab \tab Sunday \cr
\%b  \tab \tab Abbreviated month               \tab \tab May, Jul \cr
\%B  \tab \tab Full month                      \tab \tab March, July \cr
\%d  \tab \tab Day of the month                \tab \tab 27, 07 \cr
\%j  \tab \tab Day of the year                 \tab \tab 148, 188 \cr
\%m  \tab \tab Month                           \tab \tab 05, 07 \cr
\%U  \tab \tab Week, with Sunday as first day  \tab \tab 22, 27 \cr
\%w  \tab \tab Weekday, Sunday is 0            \tab \tab 0, 4 \cr
\%W  \tab \tab Week, with Monday as first day  \tab \tab 21, 27 \cr
\%x  \tab \tab Date, locale-specific           \tab \tab \cr
\%y  \tab \tab Year without century            \tab \tab 84, 05 \cr
\%Y  \tab \tab Year with century               \tab \tab 1984, 2005 \cr
\%C  \tab \tab Century                         \tab \tab 19, 20 \cr
\%D  \tab \tab Date formatted \%m/\%d/\%y      \tab \tab 07/17/23 \cr
\%u  \tab \tab Weekday, Monday is 1            \tab \tab 7, 4 \cr
}
}
\examples{
str1 <- "The video was recorded on July 19, 2023."
str2 <- "The video was recorded over a 4 hour period
starting on July 19, 2023."
str3 <- "The first batch aug 12,2024 of aug 12,
2024 reports are due on July 12, 2024; the second
batch on 7/19/24."
str4 <- c("On 3.12.25, Jerry is taking one month
05.13.1895 of leave and is not scheduled to
return until around 4-9-2025.", "The staff
will be out on training on 10/11/24,
Oct 12, 2024, and 10-13-24.")
getDate(str1)
getDate(str2, out.format = "\%Y-\%m-\%d")
getDate(str3, out.format = "\%m-\%d/\%Y")
getDate(str4)

}
