% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inc.R
\name{minus}
\alias{minus}
\title{Decrease vector by value}
\usage{
minus(., minus = 1L)
}
\arguments{
\item{.}{vector of number(s)}

\item{minus}{number to minus}
}
\value{
a vector decreased by a number
}
\description{
decrease the content of a vector and re-save as the vector
}
\details{
Similar to the inc and plus functions, the minus function is very useful when writing complex codes involving loops.
Apart from the for loop, minus can be useful to quickly decrease the value of a variable located outside the loop
by simply decreement the variable by 1 or other numbers. Check in the example section for a specific use.
Given the scope, one may also choose to use this function in any other instances, as it's simple purpose is
to decrease the value of a variable by a number and then re-save the new value to that variable.
}
\examples{
num1 <- sample(5:150,10)
num1

# decrease num1 by 1
num1 #before decrease
minus(num1)
num1 #after decrease

# decrease num1 by 5
num1 #before decrease
minus(num1, minus = 5)
num1 #after decrease



#when used in loops

#add and compare directly
rnum = 23
minus(rnum) == 220 #returns FALSE
rnum #the variable was also updated


# use in a for loop
ynum = 100

for( i in c("teacher","student","lawyer","pharmacist")){
message("This is the item number ")
message(ynum)
message(". For this item, I am a ")
message(i)

#decrement easily at each turn
minus(ynum,3)
}

#use in a repeat loop
xnum = 100
repeat{ #repeat until xnum is 85
message(xnum)
if(minus(xnum) == 85) break
}
}
