% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimator.R
\name{blocking_estimator}
\alias{blocking_estimator}
\title{Estimator for treatment effects in blocked experiments}
\usage{
blocking_estimator(outcomes, blocking, treatments)
}
\arguments{
\item{outcomes}{numeric vector with observed outcomes.}

\item{blocking}{\code{\link{qb_blocking}} or \code{\link[scclust]{scclust}} object with
the block assignments.}

\item{treatments}{factor specifying the units' treatment assignments.}
}
\value{
A list with two numeric matrices with estimated treatment effects and
   their estimated variances is returned. The first matrix (\code{effects})
   contains estimated treatment effects. Rows in this matrix indicate minuends
   in the treatment effect contrast and columns indicate subtrahends. For
   example, in the matrix:
   \tabular{rrrr}{
     \tab a \tab b \tab c\cr
     a \tab 0.0 \tab 4.5 \tab 5.5\cr
     b \tab -4.5 \tab 0.0 \tab 1.0\cr
     c \tab -5.5 \tab -1.0 \tab 0.0\cr
   }
   the estimated treatment effect between conditions \eqn{a} and \eqn{b} is
   \eqn{4.5}, and the estimated treatment effect between conditions \eqn{c}
   and \eqn{b} is \eqn{-1.0}.

   The second matrix (\code{effect_variances}) contains estimates of
   variances of the corresponding effect estimators.
}
\description{
\code{blocking_estimator} estimates treatment effects in blocked experiments.
The function expects the user to provide the outcomes, a blocking object
and treatment assignments. It returns point estimates of sample average
treatment effects and variance estimates.
}
\details{
To produce point estimates, \code{blocking_estimator} requires that each block
contains at least one unit assigned to each treatment condition. For variance
estimation, it requires that each block contains at least two units assigned to
each condition. When treatments have been assigned with the
\code{\link{assign_treatment}} function (or an equivalent procedure), the
variance estimators are conservative in expectation (see the referenced
note below for details). If treatment is assigned with another method, the
estimator might not be valid.

The function estimates treatment effects by aggregating block-level
effect estimates. It estimates effects within each block by taking the difference
in mean outcomes in the block. The sample-level estimate is then derived as the
weighted average of the block-level effects using the size of the blocks as weights.
In detail, let \eqn{n_b} be the number of units assigned to block \eqn{b}, and
\eqn{n} be the total number of units in the sample. Let \eqn{Y(t, b)} be the
average outcome for units assigned to treatment \eqn{t} in block \eqn{b}. The
effect of treatment \eqn{t} versus treatment \eqn{s} is then estimated as:

\deqn{\sum\frac{n_b}{n}[Y(t, b) - Y(s, b)],}

where the sum is taken over the blocks in the experiment. See the referenced note
for more details.
}
\examples{
# Example blocking
my_blocking <- qb_blocking(c("A", "A", "B", "C", "B",
                             "C", "B", "C", "B", "A",
                             "C", "C", "A", "B", "B",
                             "B", "B", "A", "A", "C"))

# Two treatment conditions
my_treatments <- assign_treatment(my_blocking)
my_outcomes <- rnorm(20)
blocking_estimator(my_outcomes, my_blocking, my_treatments)

# Three treatment conditions
my_treatments <- assign_treatment(my_blocking, c("T1", "T2", "C"))
my_outcomes <- rnorm(20)
blocking_estimator(my_outcomes, my_blocking, my_treatments)

# Four treatment conditions
# (This will throw an error because variances cannot be estimated)
my_treatments <- assign_treatment(my_blocking, c("T1", "T2", "T3", "C"))
my_outcomes <- rnorm(20)
\dontrun{blocking_estimator(my_outcomes, my_blocking, my_treatments)}

}
\references{
Higgins, Michael J., Fredrik Sävje and Jasjeet S. Sekhon (2015),
   \sQuote{Blocking estimators and inference under the Neyman-Rubin model},
   arXiv 1510.01103. \url{https://arxiv.org/abs/1510.01103}
}
