% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_alias.R
\name{extract_alias}
\alias{extract_alias}
\title{Extract the column alias from a SQL expression}
\usage{
extract_alias(expr)
}
\arguments{
\item{expr}{a character string containing a SQL expression which might have a
column alias assignment at the end}
}
\value{
a character string containing the inputted SQL expression with the
  column alias assignment removed (if it existed) and with the assigned alias
  as its name
}
\description{
Extracts the column alias assignment from an expression used in
  the \code{SELECT} list of a SQL query
}
\details{
The expression must not contain any unquoted whitespace characters
  except spaces, and there must be no unquoted runs or two or more spaces.
  Use \code{\link{squish_sql}} to satisfy this whitespace requirement.
}
\examples{
expr <- "round(AVG(arr_delay)) AS avg_delay"
extract_alias(expr)
}
