% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{quarto_add_extension}
\alias{quarto_add_extension}
\title{Install a Quarto extensions}
\usage{
quarto_add_extension(
  extension = NULL,
  no_prompt = FALSE,
  quiet = FALSE,
  quarto_args = NULL
)
}
\arguments{
\item{extension}{The extension to install, either an archive or a GitHub
repository as described in the documentation
\url{https://quarto.org/docs/extensions/managing.html}.}

\item{no_prompt}{Do not prompt to confirm approval to download external extension.}

\item{quiet}{Suppress warning and other messages.}

\item{quarto_args}{Character vector of other \code{quarto} CLI arguments to append
to the Quarto command executed by this function. This is mainly intended for
advanced usage and useful for CLI arguments which are not yet mirrored in a
dedicated parameter of this \R function. See \verb{quarto render --help} for options.}
}
\description{
Add an extension to this folder or project by running \verb{quarto add}
}
\section{Extension Trust}{
Quarto extensions may execute code when documents are rendered. Therefore, if
you do not trust the author of an extension, we recommend that you do not
install or use the extension.
By default \code{no_prompt = FALSE} which means that
the function will ask for explicit approval when used interactively, or
disallow installation.
}

\examples{
\dontrun{
# Install a template and set up a draft document from a GitHub repository
quarto_add_extension("quarto-ext/fontawesome")

# Install a template and set up a draft document from a ZIP archive
quarto_add_extension("https://github.com/quarto-ext/fontawesome/archive/refs/heads/main.zip")
}

}
