% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-LagOperator.R
\docType{class}
\name{LagOperator-class}
\alias{LagOperator}
\alias{LagOperator-class}
\title{Interface Class to access different types of operators on time series.}
\description{
\code{LagOperator} is an S4 class that provides a common interface to
implementations of an operator \eqn{\Gamma(Y)}{Gamma(Y)} which is calculated on
all pairs of observations \eqn{(Y_0,Y_k)}{(Y0,Yk)} with lag smaller than maxLag
}
\details{
Currently one implementation is available:
    (1) \code{\link{ClippedCov}}.
}
\section{Slots}{

\describe{
\item{\code{values}}{an array of dimension \code{c(maxLag,length(levels.1),length(levels.2))}
containing the values of the operator.}

\item{\code{Y}}{is the time series the operator shall be applied to}

\item{\code{maxLag}}{maximum lag between two observations}

\item{\code{levels}}{a vector of numerics that determines the levels of the operator}

\item{\code{isRankBased}}{A flag that is \code{FALSE} if the determined \code{values}
are based on the original time series and \code{TRUE} if it
is based on the ranks.}

\item{\code{positions.boot}}{An object of type \code{\link{BootPos}},
that is used to determine the block bootstrapped
replicates of the time series.}

\item{\code{B}}{Number of bootstrap replications to perform.}
}}
\keyword{S4-classes}

