% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/Class-QuantileSD.R
\docType{methods}
\name{getMeanPG-QuantileSD}
\alias{getMeanPG,QuantileSD-method}
\alias{getMeanPG-QuantileSD}
\title{Get \code{meanPG} from a quantile spectral density kernel}
\usage{
\S4method{getMeanPG}{QuantileSD}(object, frequencies = 2 * pi *
  (0:(getN(object) - 1))/getN(object), levels.1 = getLevels(object, 1),
  levels.2 = getLevels(object, 2))
}
\arguments{
\item{object}{\code{QuantileSD} of which to get the \code{meanPG}}

\item{frequencies}{a vector of frequencies for which to get the \code{meanPG}}

\item{levels.1}{the first vector of levels for which to get the \code{meanPG}}

\item{levels.2}{the second vector of levels for which to get the \code{meanPG}}
}
\value{
Returns the array \code{meanPG} that's a slot of \code{object}.
}
\description{
The selection mechanism for frequencies and levels operates in the same way
as described in \code{\link{getValues-QuantileSD}}. The format of the
output is also described there.
}
\keyword{Access-functions}

