% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/char_select.R
\name{char_select}
\alias{char_select}
\alias{char_remove}
\alias{char_keep}
\title{Select or remove elements from a character vector}
\usage{
char_select(
  x,
  pattern,
  selection = c("keep", "remove"),
  valuetype = c("glob", "fixed", "regex"),
  case_insensitive = TRUE
)

char_remove(x, ...)

char_keep(x, ...)
}
\arguments{
\item{x}{an input \link{character} vector}

\item{pattern}{a character vector, list of character vectors, \link{dictionary},
or collocations object.  See \link{pattern} for details.}

\item{selection}{whether to \code{"keep"} or \code{"remove"} the tokens matching
\code{pattern}}

\item{valuetype}{the type of pattern matching: \code{"glob"} for "glob"-style
wildcard expressions; \code{"regex"} for regular expressions; or \code{"fixed"} for
exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{logical; if \code{TRUE}, ignore case when matching a
\code{pattern} or \link{dictionary} values}

\item{...}{additional arguments passed by \code{char_remove} and \code{char_keep} to
\code{char_select}. Cannot include \code{selection}.}
}
\value{
a modified \link{character} vector
}
\description{
These function select or discard elements from a \link{character} object.  For
convenience, the functions \code{char_remove} and \code{char_keep} are defined as
shortcuts for \code{char_select(x, pattern, selection = "remove")} and
\code{char_select(x, pattern, selection = "keep")}, respectively.

These functions make it easy to change, for instance, stopwords
based on pattern matching.
}
\examples{
# character selection
mykeywords <- c("natural", "national", "denatured", "other")
char_select(mykeywords, "nat*", valuetype = "glob")
char_select(mykeywords, "nat", valuetype = "regex")
char_select(mykeywords, c("natur*", "other"))
char_select(mykeywords, c("natur*", "other"), selection = "remove")

# character removal
char_remove(letters[1:5], c("a", "c", "x"))
words <- c("any", "and", "Anna", "as", "announce", "but")
char_remove(words, "an*")
char_remove(words, "an*", case_insensitive = FALSE)
char_remove(words, "^.n.+$", valuetype = "regex")

# remove some of the system stopwords
stopwords("en", source = "snowball")[1:6]
stopwords("en", source = "snowball")[1:6] |>
  char_remove(c("me", "my*"))
  
# character keep
char_keep(letters[1:5], c("a", "c", "x"))
}
