% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenizers.R
\name{tokenize_custom}
\alias{tokenize_custom}
\alias{breakrules_get}
\alias{breakrules_set}
\alias{breakrules_reset}
\title{Customizable tokenizer}
\source{
\url{https://raw.githubusercontent.com/unicode-org/icu/main/icu4c/source/data/brkitr/rules/word.txt}

\url{https://raw.githubusercontent.com/unicode-org/icu/main/icu4c/source/data/brkitr/rules/sent.txt}
}
\usage{
tokenize_custom(x, rules)

breakrules_get(what = c("word", "sentence"))

breakrules_set(x, what = c("word", "sentence"))

breakrules_reset(what = c("word", "sentence"))
}
\arguments{
\item{x}{character vector for texts to tokenize}

\item{rules}{a list of rules for rule-based boundary detection}

\item{what}{character; which set of rules to return, one of \code{"word"} or
\code{"sentence"}}
}
\value{
\code{tokenize_custom()} returns a list of characters containing tokens.

\code{breakrules_get()} returns the existing break rules as a list.

\code{breakrules_set()} returns nothing but reassigns the global
breakrules to \code{x}.

\code{breakrules_reset()} returns nothing but reassigns the global
breakrules to the system defaults.  These rules are defined in
\code{system.file("breakrules/")}.
}
\description{
Allows users to tokenize texts using customized boundary rules. See the \href{https://unicode-org.github.io/icu/userguide/boundaryanalysis/break-rules.html}{ICU website}
for how to define boundary rules.

Tools for custom word and sentence breakrules, to retrieve, set, or reset
them to package defaults.
}
\details{
The package contains internal sets of rules for word and sentence
breaks, which are lists
of rules for word and sentence boundary detection. \code{base} is copied from
the ICU library. Other rules are created by the package maintainers in
\code{system.file("breakrules/breakrules_custom.yml")}.

This function allows modification of those rules, and applies them as a new
tokenizer.

Custom word rules:
\describe{
\item{\code{base}}{ICU's rules for detecting word/sentence boundaries}
\item{\code{keep_hyphens}}{quanteda's rule for preserving hyphens}
\item{\code{keep_url}}{quanteda's rule for preserving URLs}
\item{\code{keep_email}}{quanteda's rule for preserving emails}
\item{\code{keep_tags}}{quanteda's rule for preserving tags}
\item{\code{split_elisions}}{quanteda's rule for splitting elisions}
\item{\code{split_tags}}{quanteda's rule for splitting tags}
}
}
\examples{
lis <- tokenize_custom("a well-known http://example.com", rules = breakrules_get("word"))
tokens(lis, remove_separators = TRUE)
breakrules_get("word")
breakrules_get("sentence")

brw <- breakrules_get("word")
brw$keep_email <- "@[a-zA-Z0-9_]+"
breakrules_set(brw, what = "word")
breakrules_reset("sentence")
breakrules_reset("word")
}
\keyword{internal}
