% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-methods.R
\name{featnames}
\alias{featnames}
\title{Get the feature labels from a dfm}
\usage{
featnames(x)
}
\arguments{
\item{x}{the dfm whose features will be extracted}
}
\value{
character vector of the feature labels
}
\description{
Get the features from a document-feature matrix, which are stored as the
column names of the \link{dfm} object.
}
\examples{
dfmat <- dfm(data_corpus_inaugural)

# first 50 features (in original text order)
head(featnames(dfmat), 50)

# first 50 features alphabetically
head(sort(featnames(dfmat)), 50)

# contrast with descending total frequency order from topfeatures()
names(topfeatures(dfmat, 50))
}
