% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel-wordfish.R
\name{textmodel_wordfish}
\alias{textmodel_wordfish}
\title{wordfish text model}
\usage{
textmodel_wordfish(data, dir = c(1, 2), priors = c(Inf, Inf, 3, 1),
  tol = c(1e-06, 1e-08), dispersion = c("poisson", "quasipoisson"),
  dispersionLevel = c("feature", "overall"), dispersionFloor = 0)
}
\arguments{
\item{data}{the dfm on which the model will be fit}

\item{dir}{set global identification by specifying the indexes for a pair of 
documents such that \eqn{\hat{\theta}_{dir[1]} < \hat{\theta}_{dir[2]}}.}

\item{priors}{prior precisions for the estimated parameters \eqn{\alpha_i}, 
\eqn{\psi_j}, \eqn{\beta_j}, and \eqn{\theta_i}, where \eqn{i} indexes 
documents and \eqn{j} indexes features}

\item{tol}{tolerances for convergence.  The first value is a convergence 
threshold for the log-posterior of the model, the second value is the 
tolerance in the difference in parameter values from the iterative 
conditional maximum likelihood (from conditionally estimating 
document-level, then feature-level parameters).}

\item{dispersion}{sets whether a quasi-poisson quasi-likelihood should be 
used based on a single dispersion parameter (\code{"poisson"}), or 
quasi-Poisson (\code{"quasipoisson"})}

\item{dispersionLevel}{sets the unit level for the dispersion parameter, 
options are \code{"feature"} for term-level variances, or \code{"overall"} 
for a single dispersion parameter}

\item{dispersionFloor}{constraint for the minimal underdispersion multiplier 
in the quasi-Poisson model.  Used to minimize the distorting effect of 
terms with rare term or document frequencies that appear to be severely 
underdispersed.  Default is 0, but this only applies if \code{dispersion = 
"quasipoisson"}.}
}
\value{
An object of class textmodel_fitted_wordfish.  This is a list 
  containing: \item{dir}{global identification of the dimension} 
  \item{theta}{estimated document positions} \item{alpha}{estimated document 
  fixed effects} \item{beta}{estimated feature marginal effects} 
  \item{psi}{estimated word fixed effects} \item{docs}{document labels} 
  \item{features}{feature labels} \item{sigma}{regularization parameter for 
  betas in Poisson form} \item{ll}{log likelihood at convergence} 
  \item{se.theta}{standard errors for theta-hats} \item{data}{dfm to which 
  the model was fit}
}
\description{
Estimate Slapin and Proksch's (2008) "wordfish" Poisson scaling model of 
one-dimensional document positions using conditional maximum likelihood.
}
\details{
The returns match those of Will Lowe's R implementation of 
  \code{wordfish} (see the austin package), except that here we have renamed 
  \code{words} to be \code{features}.  (This return list may change.)  We 
  have also followed the practice begun with Slapin and Proksch's early 
  implementation of the model that used a regularization parameter of 
  se\eqn{(\sigma) = 3}, through the third element in \code{priors}.
}
\examples{
textmodel_wordfish(data_dfm_LBGexample, dir = c(1,5))

\dontrun{
ie2010dfm <- dfm(data_corpus_irishbudget2010, verbose = FALSE)
(wfm1 <- textmodel_wordfish(ie2010dfm, dir = c(6,5)))
(wfm2a <- textmodel_wordfish(ie2010dfm, dir = c(6,5), 
                             dispersion = "quasipoisson", dispersionFloor = 0))
(wfm2b <- textmodel_wordfish(ie2010dfm, dir = c(6,5), 
                             dispersion = "quasipoisson", dispersionFloor = .5))
plot(wfm2a@phi, wfm2b@phi, xlab = "Min underdispersion = 0", ylab = "Min underdispersion = .5",
     xlim = c(0, 1.0), ylim = c(0, 1.0))
plot(wfm2a@phi, wfm2b@phi, xlab = "Min underdispersion = 0", ylab = "Min underdispersion = .5",
     xlim = c(0, 1.0), ylim = c(0, 1.0), type = "n")
underdispersedTerms <- sample(which(wfm2a@phi < 1.0), 5)
which(featnames(ie2010dfm) \%in\% names(topfeatures(ie2010dfm, 20)))
text(wfm2a@phi, wfm2b@phi, wfm2a@features, 
     cex = .8, xlim = c(0, 1.0), ylim = c(0, 1.0), col = "grey90")
text(wfm2a@phi[underdispersedTerms], wfm2b@phi[underdispersedTerms], 
     wfm2a@features[underdispersedTerms], 
     cex = .8, xlim = c(0, 1.0), ylim = c(0, 1.0), col = "black")
if (require(austin)) {
    wfmodelAustin <- austin::wordfish(quanteda::as.wfm(ie2010dfm), dir = c(6,5))
    cor(wfm1@theta, wfm1Austin$theta)
}}
}
\author{
Benjamin Lauderdale and Kenneth Benoit
}
\references{
Jonathan Slapin and Sven-Oliver Proksch.  2008. "A Scaling Model 
  for Estimating Time-Series Party Positions from Texts." \emph{American 
  Journal of Political Science} 52(3):705-772.
  
  Lowe, Will and Kenneth Benoit. 2013. "Validating Estimates of Latent Traits
  from Textual Data Using Human Judgment as a Benchmark." \emph{Political Analysis}
  21(3), 298-313. \url{http://doi.org/10.1093/pan/mpt002}
}

