% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R, R/textfile.R
\name{docvars}
\alias{docvars}
\alias{docvars.corpus}
\alias{docvars.corpusSource}
\alias{docvars<-}
\alias{docvars<-.corpus}
\title{get or set for document-level variables}
\usage{
docvars(x, field = NULL)

\method{docvars}{corpus}(x, field = NULL)

docvars(x, field = NULL) <- value

\method{docvars}{corpus}(x, field = NULL) <- value

\method{docvars}{corpusSource}(x, field = NULL)
}
\arguments{
\item{x}{corpus whose document-level variables will be read or set}

\item{field}{string containing the document-level variable name}

\item{value}{the new values of the document-level variable}
}
\value{
\code{docvars} returns a data.frame of the document-level variables

\code{docvars<-} assigns \code{value} to the named \code{field}
}
\description{
Get or set variables for the documents in a corpus
}
\note{
Another way to access and set docvars is through indexing of the corpus \code{j} element, 
such as \code{ie2010Corpus[, c("foren", "name"]} or for a single docvar, \code{ie2010Corpus[["name"]]}.  The latter
also permits assignment, including the easy creation of new document varibles, e.g. \code{ie2010Corpus[["newvar"]] <- 1:ndoc(ie2010Corpus)}.
See \code{\link{[.corpus}} for details.
}
\examples{
head(docvars(inaugCorpus))
docvars(inaugCorpus, "President") <- paste("prez", 1:ndoc(inaugCorpus), sep="")
head(docvars(inaugCorpus))

# alternative using indexing
head(inaugCorpus[, "Year"])
inaugCorpus[["President2"]] <- paste("prezTwo", 1:ndoc(inaugCorpus), sep="")
head(docvars(inaugCorpus))
}

