% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qm_validate.R
\name{qm_validate}
\alias{qm_validate}
\title{Validate input vector}
\usage{
qm_validate(ref, key, value)
}
\arguments{
\item{ref}{An \code{sf} object that serves as a master list of features}

\item{key}{Name of geographic id variable in the \code{ref} object to match input values to}

\item{value}{A vector of input values created with \code{qm_define}}
}
\value{
A logical scalar that is \code{TRUE} is all input values match values in the key variable.
}
\description{
This function ensures that the input vector values match valid values in a source shapefile.
}
\examples{
# load and format reference data
stl <- stLouis
stl <- dplyr::mutate(stl, TRACTCE = as.numeric(TRACTCE))

# create clusters
clusterValid <- qm_define(118600, 119101, 119300)
clusterError <- qm_define(118600, 119101, 800000)

# validate clusters
qm_validate(ref = stl, key = TRACTCE, value = clusterValid)

qm_validate(ref = stl, key = TRACTCE, value = clusterError)

}
\seealso{
\code{qm_define}
}
