% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{habitat}
\alias{habitat}
\alias{habitat_roads}
\title{Sample raster data for the \code{quadtree} package}
\format{
\code{\link[raster:RasterLayer-class]{RasterLayer}}
}
\usage{
data(habitat)
data(habitat_roads)
}
\description{
\code{habitat} is a \code{\link[raster:RasterLayer-class]{RasterLayer}}
containing habitat suitability values where each cell takes on a value
between 0 and 1.

\code{habitat_roads} is a \code{\link[raster:RasterLayer-class]{RasterLayer}}
with the exact same footprint as \code{habitat}, but the values represent the
presence/absence of roads in that cell. 1 indicates presence, while 0
indicates absence.
}
\details{
These rasters are included for two reasons. First, they provide the datasets
that are used for the code examples in the help files and the vignettes.
Second, they provide easy-to-access datasets for users to experiment with
when learning how to use the \code{quadtree} package.
}
\examples{
library(quadtree)
data(habitat)
data(habitat_roads)

old_par <- par(mfrow = c(1, 2))
plot(habitat)
plot(habitat_roads)

qt1 <- quadtree(habitat, .1)
qt2 <- quadtree(habitat_roads, .1)

plot(qt1, crop = TRUE, na_col = NULL, border_lwd = .3)
plot(qt2, crop = TRUE, na_col = NULL, border_lwd = .3)

par(old_par)
}
