% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_gg.R
\name{write_gg}
\alias{write_gg}
\title{Save ggplot Objects to Files}
\usage{
write_gg(
  gg_obj = NULL,
  file = NULL,
  target_dir = NULL,
  device = "pdf",
  theme = NULL,
  ...
)
}
\arguments{
\item{gg_obj}{The ggplot to be written. If not specified, the last
ggplot created will be written.}

\item{file}{The name of the file to be written. If not specified, the
label of the code block will be used.}

\item{target_dir}{The directory where the file will be written. If not
specified, the current working directory will be used.}

\item{device}{The device to be used for saving the ggplot. Options
include "pdf" (default), "png", "jpeg", "tiff", and "svg".}

\item{theme}{The ggplot2 theme to be applied to the ggplot. Default is
the theme specified in the ggplot2 options.}

\item{...}{Additional arguments to be passed to the \code{ggsave}
function from the \code{ggplot2} package.}
}
\value{
The path of the written file.
}
\description{
A wrapper around \code{ggsave} that facilitates saving ggplot objects within knitr
documents. Automatically handles file naming and directory creation, with
support for multiple output formats.
}
\details{
This function extends \code{ggplot2::ggsave} by:
\itemize{
\item Using knitr code block labels for automatic file naming
\item Creating target directories if they don't exist
\item Supporting multiple output formats (PDF, PNG, JPEG, TIFF, SVG)
\item Applying custom themes to plots before saving
}
}
\examples{
\dontrun{
library(ggplot2)

plot_dir <- file.path(tempdir(), "plot")

# Write a ggplot object as a PDF file
p <- ggplot(mtcars, aes(x = wt, y = mpg)) +
  geom_point()

write_gg(
  gg_obj = p,
  file = "plot_file",
  target_dir = plot_dir,
  device = "pdf"
)

unlink(plot_dir)
}
}
\keyword{publishing}
