% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqgate.R
\name{Ri}
\alias{Ri}
\title{The Ri gate}
\usage{
Ri(bit, i, sign = +1)
}
\arguments{
\item{bit}{integer. The bit to which to apply the gate}

\item{i}{integer}

\item{sign}{integer}
}
\value{
An S4 class 'sqgate' object is returned
}
\description{
The Ri gate
}
\details{
Implements the gate
( 1   0                )
( 0   exp(+-2\emph{pi}1i/2^i) )

If 'sign < 0', the inverse of the exponential is used.
This gate is up to global phase identical with the 'Rz'
gate with specific values of the angle.
}
\examples{
x <- X(1) * qstate(nbits=2)
z <- Ri(1, i=2) * x
z

}
