% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_files.R
\name{qread}
\alias{qread}
\title{qread}
\usage{
qread(file, use_alt_rep=FALSE, strict=FALSE, nthreads=1)
}
\arguments{
\item{file}{the file name/path}

\item{use_alt_rep}{Use alt rep when reading in string data.  Default: FALSE.  (Note: on R versions earlier than 3.5.0, this parameter does nothing.)}

\item{strict}{Whether to throw an error or just report a warning (Default: FALSE, report warning)}

\item{nthreads}{Number of threads to use.  Default 1.}
}
\value{
The de-serialized object
}
\description{
Reads an object in a file serialized to disk
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE), 
                 num = rnorm(1e3), 
                 char = randomStrings(1e3), stringsAsFactors = FALSE)
myfile <- tempfile()
qsave(x, myfile)
x2 <- qread(myfile)
identical(x, x2) # returns true

# qs support multithreading
qsave(x, myfile, nthreads=2)
x2 <- qread(myfile, nthreads=2)
identical(x, x2) # returns true

# Other examples
z <- 1:1e7
myfile <- tempfile()
qsave(z, myfile)
z2 <- qread(myfile)
identical(z, z2) # returns true

w <- as.list(rnorm(1e6))
myfile <- tempfile()
qsave(w, myfile)
w2 <- qread(myfile)
identical(w, w2) # returns true
}
