% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_qqboxplot.R
\name{stat_qqboxplot}
\alias{stat_qqboxplot}
\title{Compute values for the Q-Q Boxplot}
\usage{
stat_qqboxplot(
  mapping = NULL,
  data = NULL,
  geom = "qqboxplot",
  position = "dodge2",
  ...,
  coef = 1.5,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  reference_dist = "norm",
  confidence_level = 0.95,
  numboots = 500,
  compdata = NULL
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default connection between
\code{geom_boxplot} and \code{stat_boxplot}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{coef}{Length of the whiskers as multiple of IQR. Defaults to 1.5.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{reference_dist}{Specifies theoretical reference distribution.}

\item{confidence_level}{Sets confidence level for deviation whisker
confidence bands}

\item{numboots}{specifies the number of bootstrap draws for bootstrapped CIs
needed only if compdata is not NULL}

\item{compdata}{specifies a data set to use as the reference distribution.
If compdata is not NULL, the argument reference_dist will be ignored.}
}
\value{
Returns an object of class \code{StatQqboxplot}, (inherits from \code{Geom}, \code{ggproto}),
that helps to render the data for \code{geom_qqboxplot()}.
}
\description{
Compute values for the Q-Q Boxplot
}
\section{Computed variables}{

\code{stat_qqboxplot()} provides the following variables, some of which depend on the orientation:
\describe{
\item{width}{width of boxplot}
\item{ymin \emph{or} xmin}{lower whisker = smallest observation greater than or equal to lower hinge - 1.5 * IQR}
\item{lower \emph{or} xlower}{lower hinge, 25\% quantile}
\item{notchlower}{lower edge of notch = median - 1.58 * IQR / sqrt(n)}
\item{middle \emph{or} xmiddle}{median, 50\% quantile}
\item{notchupper}{upper edge of notch = median + 1.58 * IQR / sqrt(n)}
\item{upper \emph{or} xupper}{upper hinge, 75\% quantile}
\item{ymax \emph{or} xmax}{upper whisker = largest observation less than or equal to upper hinge + 1.5 * IQR}
}
}

