\name{build.q.set}
\alias{build.q.set}
\title{Q methodology: sample a Q set from a concourse}
\description{
  Subsets a concourse of items into a sample of selected items.
  Returns a dataframe with handles as row names, and languages (if applicable) as columns.
}
\usage{
build.q.set(q.concourse, q.sample, q.distribution)
}

\arguments{
  \item{q.concourse}{
    A matrix with handles as row names, (optional) languages as columns, and full item wordings in cells as produced by \code{\link{import.q.concourse}}.
  }
  \item{q.sample}{
    A character vector of handles (such as \kbd{q-is-great}).
    The items identified by the handles will be sampled.
  }
  \item{q.distribution}{
    The chosen Q distribution as a vector of integers, such as \code{c(1,3,1)}.
  }
}
\details{
  Q studies are carried out letting participants rank a \emph{sample} of statements (items), collectively referred to as the \emph{Q set}.
  These Q sets are drawn (by some sampling strategy) from a \emph{concourse}, or universe of items.
  This function subsets the concourse generated by \code{\link{import.q.concourse}}, based on a vector of handles provided, and returns it as \code{q.set}.

  The function implements a number of tests on the validity and consistency of inputs.
  
  If you are not familiar with the terminology of item \emph{handle}, \emph{ID} and \emph{wording} or the file structure expected for import functions, please read the respective sections in the documentation for \link{qmethod-package} first or consider the package \href{https://github.com/aiorazabala/qmethod/wiki/Data-management}{wiki}.
}

\value{
  Returns a matrix with handles as row names, languages (if applicable) as column names and full item wordings in cells.
}

\note{
  This function currently does \emph{not} actually \emph{draw} a sample, but merely builds the Q set from a \emph{given} sample.
  Comment and/or chip in if you like want an actual sampling feature: \url{https://github.com/aiorazabala/qmethod/issues/5}.

  This function currently requires input in the argument \code{q.distribution}, but it only checks for the sum, so if you are working with a distribution-free study that still has a fixed number of items, you can just enter a vector of length 1 with your total sum of items.
}

\author{Maximilian Held}

\seealso{
  \code{\link{import.q.concourse}},
  \code{\link{import.q.feedback}},
  \code{\link{import.q.sorts}},
  \code{\link{make.cards}}
}

\examples{
# Build a Q Set from a concourse and a sample
data(importexample)
q.set <- build.q.set(
  q.concourse = importexample$q.concourse,  # as created by import.q.concourse
  q.sample = c("life-with-q","q-uprising","r-dominance","small-village"),
  # add vector with items to be selected from concourse
  # q.sample is ideally read in from a separate *.CSV file
  q.distribution = c(1,2,1) # very simple distribution
  )
}
