% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribute_excess.R
\name{distribute_excess}
\alias{distribute_excess}
\title{Randomly distributes the excess of recorded births in a given day}
\usage{
distribute_excess(
  date.birth,
  day = "01-01",
  maximum.excess = 50,
  date.event = NULL
)
}
\arguments{
\item{date.birth}{A character vector with the dates of birth in format either "yyyy-mm-dd" or "yyyy-mm-dd hour:min:secs" (for instance, "2016-01-20 12:00:00") of a population.}

\item{day}{A character vector in format "mm-dd" with the day of the year for which the (assumed) excess must be randomly distributed. By default, "01-01".}

\item{maximum.excess}{A numeric value indicating the percentage of births registered above the average to be surpassed in the target day in order to consider that in that day
an excess of births has been artificially recorded.}

\item{date.event}{A character vector with the dates of events in format either "yyyy-mm-dd" or "yyyy-mm-dd hour:min:secs" (for instance, "2016-01-20 12:00:00") linked to the
population of births. By default, NULL. When the dates of births are linked to some dates of events and both
occur in the same year, it can happen that some imputed dates of births be posterior to the dates of events.
The inclusion of this argument (when different of NULL) avoids this possibility happening.}
}
\value{
A numeric vector of the same length and order as data.birth.
}
\description{
Randomly distributes a number of births equivalent to the excess of registered births on a given day of a year among the different days of that year.
}
\note{
We consider that in a day an excess of births has been registered if the percentage of the number of
births recorded in that day surpasses the average number of births registered during the days of the
corresponding year in a amount higher than `maximum.excess`.

An excess usually happens in official statistics on the first of January. This occurs as a consequence of
established protocols in country border systems, because when an immigrant does not know her/his day
of birth, the border officials usually record them as January, 1. This provokes an artificial peak of dates of births
in that date.
}
\examples{

dates <- c("1920-05-13", "1999-04-12", "2019-01-01", "2019-01-01",
           "2022-01-01", "2022-01-01", "2022-01-01", "2022-01-01", "2022-01-01")
distribute_excess(dates)
}
\references{
Pavia, JM and Lledo, J (2022). Estimation of the Combined Effects of Ageing and Seasonality on Mortality Risk. An application to Spain. *Journal of the Royal Statistical Society, Series A (Statistics in Society)*, 185(2), 471-497. \doi{10.1111/rssa.12769}
}
\seealso{
\code{\link{time_exposed_ins}}, \code{\link{time_exposed_outs}}
}
\author{
Josep Lledo \email{josep.lledo@uv.es}

Jose M. Pavia \email{pavia@uv.es}
}
