% Generated by roxygen2 (4.0.2): do not edit by hand
\name{list2df}
\alias{counts2list}
\alias{df2matrix}
\alias{list2df}
\alias{list_df2df}
\alias{list_vect2df}
\alias{matrix2df}
\alias{matrix2long}
\alias{vect2df}
\alias{vect2list}
\title{List/Matrix/Vector to Dataframe/List/Matrix}
\usage{
list2df(list.object, col1 = "X1", col2 = "X2")

matrix2df(matrix.object, col1 = "var1")

vect2df(vector.object, col1 = "X1", col2 = "X2", order = TRUE,
  rev = FALSE)

list_df2df(list.df.object, col1 = "X1")

list_vect2df(list.vector.object, col1 = "X1", col2 = "X2", col3 = "X3",
  order = TRUE, ...)

counts2list(mat, nm = rownames(mat))

vect2list(vector.object, use.names = TRUE, numbered.names = FALSE)

df2matrix(data.frame.object, i = 1)

matrix2long(matrix.object, col1 = "cols", col2 = "rows", col3 = "vals")
}
\arguments{
\item{list.object}{A named \code{\link[base]{list}} of vectors..}

\item{col1}{Name for column 1 (the vector elements if converting a list or
the rownames if converting a matrix).}

\item{col2}{Name for column 2 (the names of the vectors).}

\item{matrix.object}{A matrix or simple_triplet_matrix object.}

\item{vector.object}{A vector object.}

\item{order}{logical.  If \code{TRUE} the dataframe will be ordered.}

\item{rev}{logical. If \code{TRUE} and \code{order = TRUE} the dataframe will
be ordered in descending order.}

\item{list.df.object}{A list of dataframes with equal number/named of columns.}

\item{list.vector.object}{A list of dataframes with equal number/named of
columns.}

\item{col3}{The name of the third column (\code{list_vect2df}).}

\item{mat}{A matrix of counts.}

\item{nm}{A character vector of names to assign to the list.}

\item{use.names}{logical.  If \code{TRUE} and the vector is named, these
names will be transferred to the list names.}

\item{numbered.names}{logical.  If \code{TRUE} padded numbers will be used
as list names.  If \code{FALSE} the vector elements themselves will become
the list names.}

\item{data.frame.object}{A \code{data.frame} object.}

\item{i}{The column number or name to become the rownames of the
\code{matrix}.}

\item{\dots}{Further arguments passed to \code{vect2df}.}
}
\value{
\code{list2df} - Returns a dataframe with two columns.

\code{matrix2df} - Returns a dataframe.

\code{vect2df} - Returns a dataframe.

\code{list_df2df} - Returns a dataframe.

\code{list_vect2df} - Returns a dataframe.

\code{counts2list} - Returns a list of elements.

\code{vect2list} - Returns a list of named elements.

\code{df2matrix} - Returns a matrix.

\code{matrix2long} - Returns a long format dataframe.
}
\description{
\code{list2df} - Convert a named list of vectors to a dataframe.

\code{matrix2df} - Convert a matrix to a dataframe and convert the rownames
to the first column.

\code{vect2df} - Convert a named vector to a dataframe.

\code{list_df2df} - Convert a list of equal numbered/named columns to a
dataframe using the list names as the level two variable.

\code{list_vect2df} - Convert a list of named vectors to a hierarchical
dataframe.

\code{counts2list} - Convert a count matrix to a named list of elements.

\code{vect2list} - Convert a vector to a named list.

\code{df2matrix} - Convert a dataframe to a \code{matrix} and simultaneously
move a column (default is the first column) to the rownames of a
\code{matrix}.

\code{matrix2long} - Convert a matrix to a long format dataframe where column
names become column 1, row names, column 2 and the values become column 3.
}
\examples{
lst1 <- list(x=c("foo", "bar"), y=1:5)
list2df(lst1)

lst2 <- list(a=c("hello", "everybody"), b = mtcars[1:6, 1])
list2df(lst2, "col 1", "col 2")

matrix2df(mtcars)
matrix2df(cor(mtcars))
matrix2df(matrix(1:9, ncol=3))

vect2df(1:10)
vect2df(c(table(mtcars[, "gear"])))

list_df2df(list(mtcars, mtcars))

L1 <- list(a=1:10, b=1:6, c=5:8)
list_vect2df(L1)

L2 <- list(
  months=setNames(1:12, month.abb),
  numbers=1:6,
  states=setNames(factor(state.name[1:4]), state.abb[1:4])
)

list_vect2df(L2)

set.seed(10)
cnts <- data.frame(month=month.name,
    matrix(sample(0:2, 36, TRUE), ncol=3))

counts2list(cnts[, -1], cnts[, 1])
df2matrix(cnts)
counts2list(df2matrix(cnts))
counts2list(t(df2matrix(cnts)))

mat <- matrix(1:9, ncol=3)
matrix2long(mat)
matrix2long(mtcars)

\dontrun{
library(qdap)
term <- c("the ", "she", " wh")
(out <- with(raj.act.1,  termco(dialogue, person, term)))
x <- counts(out)

counts2list(x[, -c(1:2)], x[, 1])
}

vect2list(LETTERS[1:10])
vect2list(LETTERS[1:10], numbered.names = TRUE)
x <- setNames(LETTERS[1:4], paste0("Element_", 1:4))
vect2list(x)
vect2list(x, FALSE)
vect2list(x, FALSE, TRUE)
}
\seealso{
\code{\link[qdapTools]{mtabulate}}
}
\keyword{collapse}
\keyword{list}

