% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_number.R
\name{rm_number}
\alias{rm_number}
\alias{as_numeric}
\alias{as_numeric2}
\alias{ex_number}
\title{Remove/Replace/Extract Numbers}
\usage{
rm_number(
  text.var,
  trim = !extract,
  clean = TRUE,
  pattern = "@rm_number",
  replacement = "",
  extract = FALSE,
  dictionary = getOption("regex.library"),
  ...
)

as_numeric(x)

as_numeric2(x)

ex_number(
  text.var,
  trim = !extract,
  clean = TRUE,
  pattern = "@rm_number",
  replacement = "",
  extract = TRUE,
  dictionary = getOption("regex.library"),
  ...
)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white 
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped 
character will be removed.}

\item{pattern}{A character string containing a regular expression (or 
character string for \code{fixed = TRUE}) to be matched in the given 
character vector.  Default, \code{@rm_number} uses the 
\code{rm_number} regex from the regular expression dictionary from 
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the numbers are extracted into a 
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within 
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}

\item{x}{a character vector to convert to a numeric vector.}
}
\value{
\code{rm_number} - Returns a character string with number removed.

\code{as_numeric} - Returns a list of vectors of numbers.

\code{as_numeric2} - Returns an unlisted vector of numbers.
}
\description{
\code{rm_number} - Remove/replace/extract number from a string (works on 
numbers with commas, decimals and negatives).

\code{as_numeric} - A wrapper for \code{as.numeric(gsub(",", "", x))}, which
removes commas and converts a list of vectors of strings to numeric.  If the 
string cannot be converted to numeric \code{NA} is returned.

\code{as_numeric2} - A convenience function for \code{as_numeric} that 
unlists and returns a vector rather than a list.
}
\examples{
x <- c("-2 is an integer.  -4.3 and 3.33 are not.",
    "123,456 is 0 alot -123456 more than -.2", "and 3456789123 fg for 345.",
    "fg 12,345 23 .44 or 18.", "don't remove this 444,44", "hello world -.q")

rm_number(x)
ex_number(x)

##Convert to numeric
as_numeric(ex_number(x))   # retain list
as_numeric2(ex_number(x))  # unlist
}
\references{
The number regular expression was created by Jason Gray.
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_ functions: 
\code{\link{rm_abbreviation}()},
\code{\link{rm_between}()},
\code{\link{rm_bracket}()},
\code{\link{rm_caps_phrase}()},
\code{\link{rm_caps}()},
\code{\link{rm_citation_tex}()},
\code{\link{rm_citation}()},
\code{\link{rm_city_state_zip}()},
\code{\link{rm_city_state}()},
\code{\link{rm_date}()},
\code{\link{rm_default}()},
\code{\link{rm_dollar}()},
\code{\link{rm_email}()},
\code{\link{rm_emoticon}()},
\code{\link{rm_endmark}()},
\code{\link{rm_hash}()},
\code{\link{rm_nchar_words}()},
\code{\link{rm_non_ascii}()},
\code{\link{rm_non_words}()},
\code{\link{rm_percent}()},
\code{\link{rm_phone}()},
\code{\link{rm_postal_code}()},
\code{\link{rm_repeated_characters}()},
\code{\link{rm_repeated_phrases}()},
\code{\link{rm_repeated_words}()},
\code{\link{rm_tag}()},
\code{\link{rm_time}()},
\code{\link{rm_title_name}()},
\code{\link{rm_url}()},
\code{\link{rm_white}()},
\code{\link{rm_zip}()}
}
\concept{rm_ functions}
\keyword{number}
