% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldmix.R
\name{aldmix}
\alias{aldmix}
\alias{raldmix}
\alias{daldmix}
\alias{paldmix}
\alias{qaldmix}
\title{Asymmetric Laplace distribution}
\usage{
raldmix(n, mu, sigma, p)

daldmix(x, mu = 0, sigma = 1, p = 0.5)

paldmix(q, mu = 0, sigma = 1, p = 0.5, lower.tail = TRUE)

qaldmix(prob, mu = 0, sigma = 1, p = 0.5, lower.tail = TRUE)
}
\arguments{
\item{n}{: number of observations}

\item{mu}{: location parameter}

\item{sigma}{: scale parameter}

\item{p, prob}{: probability at which to calculate quantile}

\item{x, q}{: vector of quantiles}

\item{lower.tail}{: logical; decides b/w \eqn{P(X<=p)} or \eqn{P(X>p)} for p/q}
}
\value{
\itemize{
\item {\code{raldmix}} {returns a vector of random numbers from \code{AL(mu,sigma,p).}}
\item {\code{daldmix}} {returns returns density of \code{AL(mu,sigma,p)} at point x.}
\item {\code{paldmix}} {returns CDF prob of \code{AL(mu,sigma,p)} at quantile q.}
\item {\code{qaldmix}} {returns inverse CDF quantile of \code{AL(mu,sigma,p)} at prob.}
}
}
\description{
Cumulative density, probability distribution function, quantile
function and random generation for the asymmetric Laplace distribution with
quantile \eqn{p}{p}, location parameter \code{mu} and scale parameter \code{sigma}.
}
\details{
The asymmetric Laplace distribution (ALD), which has the following pdf:

\deqn{f(x;\mu,\sigma,p) = \frac{p(1-p)}{\sigma} \exp\{-\frac{(x-\mu)}{\sigma}(p-I(x \le \mu))\}}{f(x;\mu,\sigma,p) = p(1-p)/\sigma exp{-(x-\mu)/\sigma (p-I(x \le \mu))}}

If not specified, \eqn{p=0.5}, \eqn{mu = 0}, \eqn{sigma = 1}.
}
\examples{
raldmix(n = 10, mu = 5, sigma = 10, p = 0.5)
daldmix(c(4,5),mu = 0,sigma = 1,p = 0.5)
paldmix(c(1,4),mu = 0,sigma = 1,p = 0.5,lower.tail=TRUE)
qaldmix(0.5,mu = 0,sigma = 1,p = 0.5,lower.tail=TRUE)

}
\references{
Keming Yu & Jin Zhang (2005) A Three-Parameter Asymmetric Laplace Distribution
and Its Extension, Communications in Statistics - Theory and Methods, 34:9-10,
1867-1879, DOI: 10.1080/03610920500199018

Kobayashi, Genya. (2011). Gibbs Sampling Methods for Bayesian Quantile Regression.
J Stat Comput Simul. 81. 1565. 10.1080/00949655.2010.496117.
}
\seealso{
\code{\link{rgig}} for random sampling from GIG distribution
}
