% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalExpCurve.R
\name{CalExpCurve}
\alias{CalExpCurve}
\title{Calculate expression using standard curve.}
\arguments{
\item{cq.table}{The data frame of the position and Cq value.}

\item{design.table}{The data frame of the position and corresponding information.}

\item{correction}{Correct expression value by reference gene.}

\item{ref.gene}{The name of reference gene.}

\item{stat.method}{Statistical method.}

\item{ref.group}{The name of reference group.}

\item{fig.type}{Output image type, `box` represents `boxplot`, `bar` represents `barplot`.}

\item{fig.ncol}{Number of columes of figure.}
}
\value{
A list contain a table and a figure.
}
\description{
Calculate expression using standard curve.
}
\examples{
df1.path = system.file("examples", "cal.exp.curve.cq.txt", package = "qPCRtools")
df2.path = system.file("examples", "cal.expre.curve.sdc.txt", package = "qPCRtools")
df3.path = system.file("examples", "cal.exp.curve.design.txt", package = "qPCRtools")

cq.table = data.table::fread(df1.path)
curve.table = data.table::fread(df2.path)
design.table = data.table::fread(df3.path)

CalExpCurve(
  cq.table,
  curve.table,
  design.table,
  correction = TRUE,
  ref.gene = "OsUBQ",
  stat.method = "t.test",
  ref.group = "CK",
  fig.type = "box",
  fig.ncol = NULL) -> res

res[["table"]]
res[["figure"]]

}
\author{
Xiang LI <lixiang117423@gmail.com>
}
