\name{johnsonFun}
\alias{johnsonFun}
\title{ Function to perform Johnson transformations }
\description{
\code{johnsonFun} performs Johnson transformation and returns a corresponding transformation object for given data.
}
\usage{
johnsonFun(x)
}
\arguments{
  \item{x}{ a vector of numeric data }
}
\details{
\code{johnsonFun} wrappes \code{JohnsonFit} function from SuppDists package.
}
\value{
 A transformation class object is returned. transformation class objects are lists composed by following items:
  \item{type }{type of transformation, in such case: "johnson"}
  \item{parameters}{a vector or a list of parameters}
  \item{original }{original data vector}
  \item{parameters}{trasformed data vector}
}
\references{ Johnson, N.L. (1949). Systems of frequency curves generated by methods of translation. Biometrika }
\author{ Giorgio Spedicato }
\note{\code{print} and \code{plot} methods are avaible for such class }
\seealso{  \code{\link{print.transformation}}, \code{\link{plot.transformation}}, \code{\link{boxcoxFun}} }
\examples{
data(warpTiles)
warpJohnson=johnsonFun(warpTiles$warping)
print(warpJohnson)
}
\keyword{ methods }
