% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_rindex.R
\name{pystr_rindex}
\alias{pystr_rindex}
\title{Find the highest index of a substring.}
\usage{
pystr_rindex(str, sub, start = 1, end = nchar(str))
}
\arguments{
\item{str}{A character vector.}

\item{sub}{A character vector.}

\item{start}{A numeric vector.}

\item{end}{A numeric vector.}
}
\value{
A numeric vector.
}
\description{
Like \code{\link{pystr_rfind}} but raises an error if \code{sub} is not found.
}
\examples{
pystr_rindex("abcxyzabc", "abc")
pystr_rindex("12121212", "12", 4, 6)
\dontrun{
pystr_rindex("abcxyzabc", "123")
}
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.rindex}
}
\seealso{
\code{\link{pystr_index}}
}

