% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_zfill.R
\name{pystr_zfill}
\alias{pystr_zfill}
\title{Zero-pad a string.}
\usage{
pystr_zfill(str, width)
}
\arguments{
\item{str}{A string.}

\item{width}{An integer.}
}
\value{
A string.
}
\description{
Return a copy of the string left filled with ASCII \code{'0'} digits to make
a string of length \code{width}.
}
\details{
A leading sign prefix (+/-) is handled by inserting the padding after
the sign character rather than before. The original string is returned if
\code{width} is less than or equal to \code{nchar(str)}.
}
\examples{
pystr_zfill("42", 5)
pystr_zfill("-42", 5)
pystr_zfill("+42", 5)
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.zfill}
}

